# Kirby License Agreement

Published: March 15, 2022  
Source: https://getkirby.com/license/2022-03-15

## About this Agreement

While Kirby's source code is publicly available, Kirby is **not free**. To use Kirby in production, you need to [purchase a license](https://getkirby.com/buy).

This End User License Agreement (the **"Agreement"**) is fundamental to the relationship between you and us. Therefore we recommend to read this Agreement carefully before you download, install or use Kirby.

If you do not agree to this Agreement, please do not download, install or use Kirby. Installation or use of Kirby signifies that you have read, understood, and agreed to be bound by this Agreement.

## Definitions

Before we get started with the conditions of the Agreement, let's define the terms that will be used throughout it:

- When we refer to **"You"**, we mean the licensee. Before purchasing Kirby, that's the individual or company that has downloaded and/or installed Kirby for a Development Installation, Private Installation or Extension Demo. When used for a Public Site, the licensee is the individual or company that has purchased the Kirby license. If you work on a client project and have purchased the Kirby license for your client, you (and _not_ the client) are the licensee.
- When we refer to **"We"**/**"Us"**/**"Our"**, we mean the licensor, the Content Folder GmbH & Co. KG. You can find Our company and contact information on Our [contact page](https://getkirby.com/contact).
- A **"Website"** is a single Kirby project that is defined by its domain name and root directory (e.g. `https://sub.example.com` or `https://example.com/example/`). Each (sub)domain and root directory is a separate Website, even if the projects are related in any way. Exception: If You use the cross-domain multi-language feature with the same `content` folder, these domains count as the same Website.
  You may use Kirby as a headless backend or as a static site generator. In these cases the Website is defined by the domain and root directory of the user- or visitor-facing frontend(s).
- A **"Development Installation"** is a Website that is installed purely for the purposes of development and client preview. It must only be accessible by a restricted number of users (like on a personal computer, on a server in a network with restricted access or when protecting a staging website with a password that only a restricted number of users know).
- A **"Private Installation"** is a Website that is installed purely for personal use. It must only be accessible by You and Your family.
- An **"Extension Demo"** is a Website with the single purpose to showcase a free or commercial Kirby theme or Kirby plugin, as long as that Website only contains demo content. If the showcased extension is a Kirby theme, the demo content must be exactly as shipped with the theme. Demos for Kirby plugins may _not_ contain any additional content that is not needed to showcase the plugin in use.
- A **"Public Site"** is a Website that is _neither_ a Development Installation, a Private Installation nor an Extension Demo.
- An **"Update"** is defined as a Kirby release which adds smaller new features, minor functionality enhancements or bug fixes. This class of release is identified by the change of the revision to the right of the first decimal point, e.g. 3.1 to 3.2, 3.X.1 to 3.X.2 or 3.X.X.1 to 3.X.X.2.
- An **"Upgrade"** is a major Kirby release which incorporates major new features or enhancements that increase the core functionality of Kirby to a larger extent. This class of release is identified by the change of the revision to the left of the first decimal point, e.g. 3.X to 4.0.
- The **"Source Code"** is defined as the contents of all files that are provided with Kirby and that make Kirby work. This includes (but is not limited to) all PHP, JavaScript, JSON, HTML and CSS files as well as all related image and other media files.

Every time you see one of these capitalized terms in the following text, it has the meaning that has been explained above.

## Usage for a Public Site

Installing Kirby on or using it for a Public Site requires a [paid license](https://getkirby.com/buy).

As Kirby is software and software is intangible, We don't sell it as such. Instead, this Agreement grants a license for each purchase to install and use a single instance of Kirby on a **specific Website**. Additional Kirby licenses must be purchased in order to install and use Kirby on **additional Websites**.

The license is **non-exclusive** (meaning that You are not the only one who We will issue a license) and **generally non-transferable** (meaning that the one who purchases the license is the licensee).

On request, We will **transfer** a license to anyone who is also allowed to buy Kirby licenses by law and this Agreement.

We will also **reassign** a license to another Website domain and root directory of Your choice, provided that You confirm that the previous Website is no longer in operation and will not be operated with the same license in the future.

If you need to transfer your Kirby license to another individual or company (for example to your client or a new agency) or reassign it to a different project, please get in touch directly at <support@getkirby.com>.

A license is valid for all Updates of the same major Kirby release. We reserve the right to charge an **upgrade fee for Upgrade releases**. Whether a release is an Update or Upgrade is at Our sole discretion.

## Order Process

Our order process is conducted by Our online reseller [Paddle.com](https://paddle.com). Paddle.com is the Merchant of Record for all Our orders. Paddle provides all customer service inquiries and handles returns.

## Free Licenses

Kirby can be used **for free in the following cases**.

Please note that the restrictions and all other clauses of this Agreement also apply to free licenses. You may especially _not_ alter or circumvent the licensing features.

### Usage for a Development Installation

We believe that it should be possible to test and evaluate software before having to purchase a license. Also, We understand that a web project first needs to be built in a protected environment before it can be published.

Therefore, installing and using Kirby on a personal computer (like a desktop PC, notebook or tablet) or server for a Development Installation is **free** for as long as You need.

The usage of Kirby in production (with the intention to handle production data or content) is _never_ considered a Development Installation, even in internal apps or systems.

### Usage for a Private Installation

You may also install and use Kirby for **free** in Private Installations as long as they are not accessible by anyone except You and Your family.

Our [definition](#definitions) of a Private Installation allows the following use cases:

- Private sites for personal use, for example:
  - Apps for You personally (like a personal diary)
  - Apps for You as a freelancer (like a bookkeeping, invoicing or project management app)
  - Apps for Your family (like a private photo gallery)
- Experimental local Kirby setups for Your personal use (for example to try out Kirby features)

However, the following use cases are _not_ covered and need a **[paid license](#usage-for-a-public-site)**:

- Intranets for companies, authorities or organizations, no matter if on a local or public server
- (Internal) apps for teams or entire companies, authorities or organizations
- Websites that are accessible by the public, even for personal/non-commercial purposes
- Use of Kirby as a local CMS for a static or headless site without a license for the frontend domain(s)

### Usage for an Extension Demo

Extension Demos are not real Websites. We want to encourage you to build and showcase your themes and plugins.

Therefore, You may **operate Extension Demos without purchasing a license**.

Please note that this does _not_ apply to store fronts or other types of sites used to promote free or commercial themes or plugins. If such a site is built with Kirby as well, it is a Public Site and needs a **[paid license](#usage-for-a-public-site)**.

## Restrictions

### Legal Restrictions

You may only use Kirby in a manner that complies with any and all **applicable laws** in the jurisdictions in which You use Kirby. Please respect all applicable restrictions concerning **privacy and intellectual property rights**.

### Making Copies

You may make **copies of Kirby** in any machine readable form solely for purposes of **deploying a Website to a server, developing a Website on a personal computer or server or as a backup**, provided that You reproduce Kirby in its original form and with all proprietary notices on the copy.

You may _not_ reproduce Kirby or its Source Code, in whole or in part, for **any other purpose**.

### Modification of the Source Code

You may **alter, modify or extend the Source Code** for Your own use. You may also **commission a third party** to perform those modifications for You.

However You may _not_:

- **alter or circumvent the licensing features**, including (but not limited to) the license validation and payment prompts or
- **resell, redistribute or transfer** the modified or derivative version.

Please note that We **can't provide technical support** for modified or derivative versions of the Source Code.

### Your Relationship to Third Parties

You are generally _not_ allowed to **sell, assign, license, disclose, distribute, or otherwise transfer or make available** Kirby or its Source Code, in whole or in part, in any form to any third parties.

The following cases are exempted from this restriction:

- Kirby licenses may be transferred to a new licensee by requesting the transfer from Us ([see above](#usage-for-a-public-site)).
- You may create Websites for third parties (e.g. as an agency or freelancer for a client). Together with this Website, You may bill Your client for the used Kirby license. You may also include the license price in a flat rate. Please note that the licensee in both of these cases is still You unless You request to transfer the license to Your client. If Your price exceeds the price You paid to Us, You need to give Your client the option to purchase the license directly from Us.
- You may make Kirby available to customers via a Software-as-a-Service (SaaS) offering, provided You ensure that each Website has a valid Kirby license purchased either by You or Your customer. If multiple customers share a Website, each customer needs at least one license. Your offering _must not_ appear to be provided or officially endorsed by Us.
- You may make a Kirby installation available to employees or partners of You or Your Website client. You may also disclose and distribute Kirby’s Source Code to Your client together with the source code of the Website You created for them.
- You may disclose the Source Code to individuals or companies that are involved in the development or operation of Your Website (e.g. agencies, design or development freelancers, hosting providers or administrators).

E.g. the following cases are explicitly **_not_ allowed**:

- Selling, licensing or distributing a new product based on Kirby that modifies or hides Kirby’s identity as a Content Management System (CMS)
- Forking Kirby and selling the modified version ([see above](#restrictions__modification-of-the-source-code))
- Buying licenses in bulk and reselling them in your own shop
- Bundling or including Kirby’s Source Code in the publication and/or distribution of a Website’s source code or a (free or paid) theme or plugin (please use Git submodules or Composer or provide a link to Our repository or website instead)

### Disallowed Uses

The following uses of Kirby are _not_ covered by this Agreement and will result in the termination of the license:

- Direct or indirect use of Kirby in **critical infrastructure** (e.g. water and energy services, public health, financial services, public security services) or **high-risk environments** (e.g. handling of harmful or dangerous materials). The use in Websites without connection to core processes is allowed.
- Use of Kirby for Websites that contain **misinformation, hate speech or discriminating content** based on age, gender, gender identity, race, sexuality, religion, nationality, serious illnesses or disabilities, no matter who authored this content. Misinformation is defined as content that is false or misleading and may lead to significant risk of physical or societal harm.
- Use of Kirby by **companies or individuals who**:
  - lobby for, promote, derive a majority of income from or are significantly invested in:
    - the production of tobacco or weapons,
    - any prison or jail operated for profit,
    - any action or facility that supports or contributes to:
      - gambling, adversely addictive behaviours or
      - deforestation.
  - lobby against, or derive a majority of income from actions that discourage or frustrate:
    - peace,
    - access to the rights set out in the Universal Declaration of Human Rights and the Convention on the Rights of the Child,
    - peaceful assembly and association (including worker associations),
    - a safe environment or action to curtail the use of fossil fuels or to prevent climate change or
    - democratic processes.

### Other Restrictions

You may also _not_:

- **extract parts of the Source Code** for use in other programs or projects (unless the code file in question is explicitly licensed under the terms of the MIT license) or
- **remove or alter any proprietary notices** on Kirby.

## Technical Support

Technical support is **provided as described on Our website** at <https://getkirby.com>. **No representations or guarantees** are made regarding the response time in which support questions are answered, however We will do Our best to respond quickly.

We reserve the right to **limit technical support for free licenses**.

## Refund Policy

We offer a **14-day**, money back refund policy if Kirby didn't work out for Your project.

If you need a refund, please get in touch directly at <support@getkirby.com>.

## No Warranty

KIRBY IS OFFERED ON AN **"AS-IS" BASIS** AND **NO WARRANTY**, EITHER EXPRESSED OR IMPLIED, IS GIVEN. WE EXPRESSLY DISCLAIM ALL WARRANTIES OF ANY KIND, WHETHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. YOU ASSUME ALL RISK ASSOCIATED WITH THE QUALITY, PERFORMANCE, INSTALLATION AND USE OF KIRBY INCLUDING, BUT NOT LIMITED TO, THE RISKS OF PROGRAM ERRORS, DAMAGE TO EQUIPMENT, LOSS OF DATA OR SOFTWARE PROGRAMS, OR UNAVAILABILITY OR INTERRUPTION OF OPERATIONS. **YOU ARE SOLELY RESPONSIBLE** FOR DETERMINING THE APPROPRIATENESS OF USE OF KIRBY AND ASSUME ALL RISKS ASSOCIATED WITH ITS USE. THIS PARAGRAPH ALSO APPLIES TO YOU IF YOU ARE NOT THE LICENSEE (E.G. IF YOU USE KIRBY WHILE SOMEONE ELSE IS THE LICENSEE).

## Term, Termination and Modification

You may use Kirby under this Agreement until either party terminates this Agreement as described in this paragraph. Either party may **terminate the Agreement** at any time, upon notice to the other party in textual form (via email or letter). Upon termination, all or the specified **licenses granted to You will terminate**, and You will **immediately uninstall and cease all use** of Kirby. If not all licenses are terminated, You may continue to use Kirby for the Websites with active licenses. The sections entitled "No Warranty", "Indemnification" and "Limitation of Liability" will **survive any termination** of this Agreement.

We may **modify Kirby and this Agreement** with notice to You either via email or by publishing content on the Kirby website at https://getkirby.com, including but not limited to changing the functionality or appearance of Kirby. Any such modification will **become binding on You** unless You terminate this Agreement. Changes to this Agreement that constrain Your rights to a great extent will only become effective with Your approval in textual or electronic form.

## Indemnification

By accepting the Agreement, you **agree to indemnify and otherwise hold harmless** Us as well as Our officers, employees, agents, subsidiaries, affiliates and other partners from any direct, indirect, incidental, special, consequential or exemplary damages arising out of, relating to, or resulting from your use of Kirby or any other matter relating to Kirby. This paragraph also applies to you if you are not the licensee (e.g. if you use Kirby while someone else is the licensee).

## Limitation of Liability

YOU EXPRESSLY UNDERSTAND AND AGREE THAT **WE SHALL NOT BE LIABLE** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, CONSEQUENTIAL OR EXEMPLARY DAMAGES, INCLUDING BUT NOT LIMITED TO, DAMAGES FOR LOSS OF PROFITS, GOODWILL, USE, DATA OR OTHER INTANGIBLE LOSSES (EVEN IF WE HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES). SOME JURISDICTIONS DO NOT ALLOW THE EXCLUSION OF THE LIMITATION OR EXCLUSION OF LIABILITY FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES. ACCORDINGLY, **SOME OF THE ABOVE LIMITATIONS MAY NOT APPLY TO YOU**. **IN NO EVENT WILL OUR TOTAL CUMULATIVE DAMAGES EXCEED** THE FEES YOU PAID TO US UNDER THIS AGREEMENT IN THE MOST RECENT TWELVE-MONTH PERIOD. THIS PARAGRAPH ALSO APPLIES TO YOU IF YOU ARE NOT THE LICENSEE (E.G. IF YOU USE KIRBY WHILE SOMEONE ELSE IS THE LICENSEE).

## All Rights Reserved

Bastian Allgeier **owns all rights**, title and interest to Kirby (including all intellectual property rights) and **reserves all rights to Kirby** that are not expressly granted in this Agreement.

## Applicable Law & Place of Jurisdiction

1. For all disputes arising out of or in connection with this Agreement, the courts competent for Neckargemünd, Germany, shall have exclusive jurisdiction. However, We shall have the choice to file lawsuits against You before the courts competent for Your place of business.
2. If You reside in Germany, para. 1 shall only apply if You are a merchant, a legal entity under public law or a special fund under public law.
3. If You don't reside in Germany, but in a different member state of the European Union, para. 1 shall only apply if You are not a consumer under Art. 17 of the regulation (EU) No. 1215/2012. In that case, You shall be entitled to file actions against Us either at Our place of business or at the courts competent at the place where You usually reside. We, on the other hand, are only entitled to bring proceedings against You in the courts of the Member State in which You are domiciled.
4. If You neither reside in Germany nor in a member state of the EU, the applicability of para. 1 remains unaffected.

## Severability Clause

Should any provision of this Agreement be or become invalid, void or unenforceable, in whole or in part, at present or in the future, this shall not affect the validity of the remaining provisions of this Agreement. The same shall apply if a gap requiring supplementation arises after conclusion of this Agreement. The parties shall replace the invalid, void or unenforceable provision or gap requiring filling by a valid provision which in its legal or economic content takes account of the invalid, void provision and the overall content of the agreement. § Section 139 of the German Civil Code (partial invalidity) is expressly waived.

## Questions?

Due to Kirby's flexibility, you may have special use cases or requirements that don't fit this Agreement.

If that's the case or if you have any questions, feel free to get in touch: <support@getkirby.com>. We are happy to think outside the box and find custom license solutions for your creative application of Kirby.
