/**
 * @vitest-environment node
 */

import { describe, expect, it } from "vitest";
import string from "./string.js";

describe.concurrent("$helper.string.hasEmoji", () => {
	it("should identify emojis", () => {
		const emojis = [
			"😀",
			"😃",
			"😄",
			"😁",
			"😆",
			"😅",
			"🤣",
			"😂",
			"🙂",
			"🙃",
			"😉",
			"😊",
			"😇",
			"🥰",
			"😍",
			"🤩",
			"😘",
			"😗",
			"☺️",
			"☺",
			"😚",
			"😙",
			"🥲",
			"😋",
			"😛",
			"😜",
			"🤪",
			"😝",
			"🤑",
			"🤗",
			"🤭",
			"🤫",
			"🤔",
			"🤐",
			"🤨",
			"😐",
			"😑",
			"😶",
			"😏",
			"😒",
			"🙄",
			"😬",
			"🤥",
			"😌",
			"😔",
			"😪",
			"🤤",
			"😴",
			"😷",
			"🤒",
			"🤕",
			"🤢",
			"🤮",
			"🤧",
			"🥵",
			"🥶",
			"🥴",
			"😵",
			"🤯",
			"🤠",
			"🥳",
			"🥸",
			"😎",
			"🤓",
			"🧐",
			"😕",
			"😟",
			"🙁",
			"☹️",
			"☹",
			"😮",
			"😯",
			"😲",
			"😳",
			"🥺",
			"😦",
			"😧",
			"😨",
			"😰",
			"😥",
			"😢",
			"😭",
			"😱",
			"😖",
			"😣",
			"😞",
			"😓",
			"😩",
			"😫",
			"🥱",
			"😤",
			"😡",
			"😠",
			"🤬",
			"😈",
			"👿",
			"💀",
			"☠️",
			"☠",
			"💩",
			"🤡",
			"👹",
			"👺",
			"👻",
			"👽",
			"👾",
			"🤖",
			"😺",
			"😸",
			"😹",
			"😻",
			"😼",
			"😽",
			"🙀",
			"😿",
			"😾",
			"🙈",
			"🙉",
			"🙊",
			"💋",
			"💌",
			"💘",
			"💝",
			"💖",
			"💗",
			"💓",
			"💞",
			"💕",
			"💟",
			"❣️",
			"❣",
			"💔",
			"❤️",
			"❤",
			"🧡",
			"💛",
			"💚",
			"💙",
			"💜",
			"🤎",
			"🖤",
			"🤍",
			"💯",
			"💢",
			"💥",
			"💫",
			"💦",
			"💨",
			"🕳️",
			"🕳",
			"💣",
			"💬",
			"👁️‍🗨️",
			"👁‍🗨️",
			"👁️‍🗨",
			"👁‍🗨",
			"🗨️",
			"🗨",
			"🗯️",
			"🗯",
			"💭",
			"💤",
			"👋",
			"👋🏻",
			"👋🏼",
			"👋🏽",
			"👋🏾",
			"👋🏿",
			"🤚",
			"🤚🏻",
			"🤚🏼",
			"🤚🏽",
			"🤚🏾",
			"🤚🏿",
			"🖐️",
			"🖐",
			"🖐🏻",
			"🖐🏼",
			"🖐🏽",
			"🖐🏾",
			"🖐🏿",
			"✋",
			"✋🏻",
			"✋🏼",
			"✋🏽",
			"✋🏾",
			"✋🏿",
			"🖖",
			"🖖🏻",
			"🖖🏼",
			"🖖🏽",
			"🖖🏾",
			"🖖🏿",
			"👌",
			"👌🏻",
			"👌🏼",
			"👌🏽",
			"👌🏾",
			"👌🏿",
			"🤌",
			"🤌🏻",
			"🤌🏼",
			"🤌🏽",
			"🤌🏾",
			"🤌🏿",
			"🤏",
			"🤏🏻",
			"🤏🏼",
			"🤏🏽",
			"🤏🏾",
			"🤏🏿",
			"✌️",
			"✌",
			"✌🏻",
			"✌🏼",
			"✌🏽",
			"✌🏾",
			"✌🏿",
			"🤞",
			"🤞🏻",
			"🤞🏼",
			"🤞🏽",
			"🤞🏾",
			"🤞🏿",
			"🤟",
			"🤟🏻",
			"🤟🏼",
			"🤟🏽",
			"🤟🏾",
			"🤟🏿",
			"🤘",
			"🤘🏻",
			"🤘🏼",
			"🤘🏽",
			"🤘🏾",
			"🤘🏿",
			"🤙",
			"🤙🏻",
			"🤙🏼",
			"🤙🏽",
			"🤙🏾",
			"🤙🏿",
			"👈",
			"👈🏻",
			"👈🏼",
			"👈🏽",
			"👈🏾",
			"👈🏿",
			"👉",
			"👉🏻",
			"👉🏼",
			"👉🏽",
			"👉🏾",
			"👉🏿",
			"👆",
			"👆🏻",
			"👆🏼",
			"👆🏽",
			"👆🏾",
			"👆🏿",
			"🖕",
			"🖕🏻",
			"🖕🏼",
			"🖕🏽",
			"🖕🏾",
			"🖕🏿",
			"👇",
			"👇🏻",
			"👇🏼",
			"👇🏽",
			"👇🏾",
			"👇🏿",
			"☝️",
			"☝",
			"☝🏻",
			"☝🏼",
			"☝🏽",
			"☝🏾",
			"☝🏿",
			"👍",
			"👍🏻",
			"👍🏼",
			"👍🏽",
			"👍🏾",
			"👍🏿",
			"👎",
			"👎🏻",
			"👎🏼",
			"👎🏽",
			"👎🏾",
			"👎🏿",
			"✊",
			"✊🏻",
			"✊🏼",
			"✊🏽",
			"✊🏾",
			"✊🏿",
			"👊",
			"👊🏻",
			"👊🏼",
			"👊🏽",
			"👊🏾",
			"👊🏿",
			"🤛",
			"🤛🏻",
			"🤛🏼",
			"🤛🏽",
			"🤛🏾",
			"🤛🏿",
			"🤜",
			"🤜🏻",
			"🤜🏼",
			"🤜🏽",
			"🤜🏾",
			"🤜🏿",
			"👏",
			"👏🏻",
			"👏🏼",
			"👏🏽",
			"👏🏾",
			"👏🏿",
			"🙌",
			"🙌🏻",
			"🙌🏼",
			"🙌🏽",
			"🙌🏾",
			"🙌🏿",
			"👐",
			"👐🏻",
			"👐🏼",
			"👐🏽",
			"👐🏾",
			"👐🏿",
			"🤲",
			"🤲🏻",
			"🤲🏼",
			"🤲🏽",
			"🤲🏾",
			"🤲🏿",
			"🤝",
			"🙏",
			"🙏🏻",
			"🙏🏼",
			"🙏🏽",
			"🙏🏾",
			"🙏🏿",
			"✍️",
			"✍",
			"✍🏻",
			"✍🏼",
			"✍🏽",
			"✍🏾",
			"✍🏿",
			"💅",
			"💅🏻",
			"💅🏼",
			"💅🏽",
			"💅🏾",
			"💅🏿",
			"🤳",
			"🤳🏻",
			"🤳🏼",
			"🤳🏽",
			"🤳🏾",
			"🤳🏿",
			"💪",
			"💪🏻",
			"💪🏼",
			"💪🏽",
			"💪🏾",
			"💪🏿",
			"🦾",
			"🦿",
			"🦵",
			"🦵🏻",
			"🦵🏼",
			"🦵🏽",
			"🦵🏾",
			"🦵🏿",
			"🦶",
			"🦶🏻",
			"🦶🏼",
			"🦶🏽",
			"🦶🏾",
			"🦶🏿",
			"👂",
			"👂🏻",
			"👂🏼",
			"👂🏽",
			"👂🏾",
			"👂🏿",
			"🦻",
			"🦻🏻",
			"🦻🏼",
			"🦻🏽",
			"🦻🏾",
			"🦻🏿",
			"👃",
			"👃🏻",
			"👃🏼",
			"👃🏽",
			"👃🏾",
			"👃🏿",
			"🧠",
			"🫀",
			"🫁",
			"🦷",
			"🦴",
			"👀",
			"👁️",
			"👁",
			"👅",
			"👄",
			"👶",
			"👶🏻",
			"👶🏼",
			"👶🏽",
			"👶🏾",
			"👶🏿",
			"🧒",
			"🧒🏻",
			"🧒🏼",
			"🧒🏽",
			"🧒🏾",
			"🧒🏿",
			"👦",
			"👦🏻",
			"👦🏼",
			"👦🏽",
			"👦🏾",
			"👦🏿",
			"👧",
			"👧🏻",
			"👧🏼",
			"👧🏽",
			"👧🏾",
			"👧🏿",
			"🧑",
			"🧑🏻",
			"🧑🏼",
			"🧑🏽",
			"🧑🏾",
			"🧑🏿",
			"👱",
			"👱🏻",
			"👱🏼",
			"👱🏽",
			"👱🏾",
			"👱🏿",
			"👨",
			"👨🏻",
			"👨🏼",
			"👨🏽",
			"👨🏾",
			"👨🏿",
			"🧔",
			"🧔🏻",
			"🧔🏼",
			"🧔🏽",
			"🧔🏾",
			"🧔🏿",
			"👨‍🦰",
			"👨🏻‍🦰",
			"👨🏼‍🦰",
			"👨🏽‍🦰",
			"👨🏾‍🦰",
			"👨🏿‍🦰",
			"👨‍🦱",
			"👨🏻‍🦱",
			"👨🏼‍🦱",
			"👨🏽‍🦱",
			"👨🏾‍🦱",
			"👨🏿‍🦱",
			"👨‍🦳",
			"👨🏻‍🦳",
			"👨🏼‍🦳",
			"👨🏽‍🦳",
			"👨🏾‍🦳",
			"👨🏿‍🦳",
			"👨‍🦲",
			"👨🏻‍🦲",
			"👨🏼‍🦲",
			"👨🏽‍🦲",
			"👨🏾‍🦲",
			"👨🏿‍🦲",
			"👩",
			"👩🏻",
			"👩🏼",
			"👩🏽",
			"👩🏾",
			"👩🏿",
			"👩‍🦰",
			"👩🏻‍🦰",
			"👩🏼‍🦰",
			"👩🏽‍🦰",
			"👩🏾‍🦰",
			"👩🏿‍🦰",
			"🧑‍🦰",
			"🧑🏻‍🦰",
			"🧑🏼‍🦰",
			"🧑🏽‍🦰",
			"🧑🏾‍🦰",
			"🧑🏿‍🦰",
			"👩‍🦱",
			"👩🏻‍🦱",
			"👩🏼‍🦱",
			"👩🏽‍🦱",
			"👩🏾‍🦱",
			"👩🏿‍🦱",
			"🧑‍🦱",
			"🧑🏻‍🦱",
			"🧑🏼‍🦱",
			"🧑🏽‍🦱",
			"🧑🏾‍🦱",
			"🧑🏿‍🦱",
			"👩‍🦳",
			"👩🏻‍🦳",
			"👩🏼‍🦳",
			"👩🏽‍🦳",
			"👩🏾‍🦳",
			"👩🏿‍🦳",
			"🧑‍🦳",
			"🧑🏻‍🦳",
			"🧑🏼‍🦳",
			"🧑🏽‍🦳",
			"🧑🏾‍🦳",
			"🧑🏿‍🦳",
			"👩‍🦲",
			"👩🏻‍🦲",
			"👩🏼‍🦲",
			"👩🏽‍🦲",
			"👩🏾‍🦲",
			"👩🏿‍🦲",
			"🧑‍🦲",
			"🧑🏻‍🦲",
			"🧑🏼‍🦲",
			"🧑🏽‍🦲",
			"🧑🏾‍🦲",
			"🧑🏿‍🦲",
			"👱‍♀️",
			"👱‍♀",
			"👱🏻‍♀️",
			"👱🏻‍♀",
			"👱🏼‍♀️",
			"👱🏼‍♀",
			"👱🏽‍♀️",
			"👱🏽‍♀",
			"👱🏾‍♀️",
			"👱🏾‍♀",
			"👱🏿‍♀️",
			"👱🏿‍♀",
			"👱‍♂️",
			"👱‍♂",
			"👱🏻‍♂️",
			"👱🏻‍♂",
			"👱🏼‍♂️",
			"👱🏼‍♂",
			"👱🏽‍♂️",
			"👱🏽‍♂",
			"👱🏾‍♂️",
			"👱🏾‍♂",
			"👱🏿‍♂️",
			"👱🏿‍♂",
			"🧓",
			"🧓🏻",
			"🧓🏼",
			"🧓🏽",
			"🧓🏾",
			"🧓🏿",
			"👴",
			"👴🏻",
			"👴🏼",
			"👴🏽",
			"👴🏾",
			"👴🏿",
			"👵",
			"👵🏻",
			"👵🏼",
			"👵🏽",
			"👵🏾",
			"👵🏿",
			"🙍",
			"🙍🏻",
			"🙍🏼",
			"🙍🏽",
			"🙍🏾",
			"🙍🏿",
			"🙍‍♂️",
			"🙍‍♂",
			"🙍🏻‍♂️",
			"🙍🏻‍♂",
			"🙍🏼‍♂️",
			"🙍🏼‍♂",
			"🙍🏽‍♂️",
			"🙍🏽‍♂",
			"🙍🏾‍♂️",
			"🙍🏾‍♂",
			"🙍🏿‍♂️",
			"🙍🏿‍♂",
			"🙍‍♀️",
			"🙍‍♀",
			"🙍🏻‍♀️",
			"🙍🏻‍♀",
			"🙍🏼‍♀️",
			"🙍🏼‍♀",
			"🙍🏽‍♀️",
			"🙍🏽‍♀",
			"🙍🏾‍♀️",
			"🙍🏾‍♀",
			"🙍🏿‍♀️",
			"🙍🏿‍♀",
			"🙎",
			"🙎🏻",
			"🙎🏼",
			"🙎🏽",
			"🙎🏾",
			"🙎🏿",
			"🙎‍♂️",
			"🙎‍♂",
			"🙎🏻‍♂️",
			"🙎🏻‍♂",
			"🙎🏼‍♂️",
			"🙎🏼‍♂",
			"🙎🏽‍♂️",
			"🙎🏽‍♂",
			"🙎🏾‍♂️",
			"🙎🏾‍♂",
			"🙎🏿‍♂️",
			"🙎🏿‍♂",
			"🙎‍♀️",
			"🙎‍♀",
			"🙎🏻‍♀️",
			"🙎🏻‍♀",
			"🙎🏼‍♀️",
			"🙎🏼‍♀",
			"🙎🏽‍♀️",
			"🙎🏽‍♀",
			"🙎🏾‍♀️",
			"🙎🏾‍♀",
			"🙎🏿‍♀️",
			"🙎🏿‍♀",
			"🙅",
			"🙅🏻",
			"🙅🏼",
			"🙅🏽",
			"🙅🏾",
			"🙅🏿",
			"🙅‍♂️",
			"🙅‍♂",
			"🙅🏻‍♂️",
			"🙅🏻‍♂",
			"🙅🏼‍♂️",
			"🙅🏼‍♂",
			"🙅🏽‍♂️",
			"🙅🏽‍♂",
			"🙅🏾‍♂️",
			"🙅🏾‍♂",
			"🙅🏿‍♂️",
			"🙅🏿‍♂",
			"🙅‍♀️",
			"🙅‍♀",
			"🙅🏻‍♀️",
			"🙅🏻‍♀",
			"🙅🏼‍♀️",
			"🙅🏼‍♀",
			"🙅🏽‍♀️",
			"🙅🏽‍♀",
			"🙅🏾‍♀️",
			"🙅🏾‍♀",
			"🙅🏿‍♀️",
			"🙅🏿‍♀",
			"🙆",
			"🙆🏻",
			"🙆🏼",
			"🙆🏽",
			"🙆🏾",
			"🙆🏿",
			"🙆‍♂️",
			"🙆‍♂",
			"🙆🏻‍♂️",
			"🙆🏻‍♂",
			"🙆🏼‍♂️",
			"🙆🏼‍♂",
			"🙆🏽‍♂️",
			"🙆🏽‍♂",
			"🙆🏾‍♂️",
			"🙆🏾‍♂",
			"🙆🏿‍♂️",
			"🙆🏿‍♂",
			"🙆‍♀️",
			"🙆‍♀",
			"🙆🏻‍♀️",
			"🙆🏻‍♀",
			"🙆🏼‍♀️",
			"🙆🏼‍♀",
			"🙆🏽‍♀️",
			"🙆🏽‍♀",
			"🙆🏾‍♀️",
			"🙆🏾‍♀",
			"🙆🏿‍♀️",
			"🙆🏿‍♀",
			"💁",
			"💁🏻",
			"💁🏼",
			"💁🏽",
			"💁🏾",
			"💁🏿",
			"💁‍♂️",
			"💁‍♂",
			"💁🏻‍♂️",
			"💁🏻‍♂",
			"💁🏼‍♂️",
			"💁🏼‍♂",
			"💁🏽‍♂️",
			"💁🏽‍♂",
			"💁🏾‍♂️",
			"💁🏾‍♂",
			"💁🏿‍♂️",
			"💁🏿‍♂",
			"💁‍♀️",
			"💁‍♀",
			"💁🏻‍♀️",
			"💁🏻‍♀",
			"💁🏼‍♀️",
			"💁🏼‍♀",
			"💁🏽‍♀️",
			"💁🏽‍♀",
			"💁🏾‍♀️",
			"💁🏾‍♀",
			"💁🏿‍♀️",
			"💁🏿‍♀",
			"🙋",
			"🙋🏻",
			"🙋🏼",
			"🙋🏽",
			"🙋🏾",
			"🙋🏿",
			"🙋‍♂️",
			"🙋‍♂",
			"🙋🏻‍♂️",
			"🙋🏻‍♂",
			"🙋🏼‍♂️",
			"🙋🏼‍♂",
			"🙋🏽‍♂️",
			"🙋🏽‍♂",
			"🙋🏾‍♂️",
			"🙋🏾‍♂",
			"🙋🏿‍♂️",
			"🙋🏿‍♂",
			"🙋‍♀️",
			"🙋‍♀",
			"🙋🏻‍♀️",
			"🙋🏻‍♀",
			"🙋🏼‍♀️",
			"🙋🏼‍♀",
			"🙋🏽‍♀️",
			"🙋🏽‍♀",
			"🙋🏾‍♀️",
			"🙋🏾‍♀",
			"🙋🏿‍♀️",
			"🙋🏿‍♀",
			"🧏",
			"🧏🏻",
			"🧏🏼",
			"🧏🏽",
			"🧏🏾",
			"🧏🏿",
			"🧏‍♂️",
			"🧏‍♂",
			"🧏🏻‍♂️",
			"🧏🏻‍♂",
			"🧏🏼‍♂️",
			"🧏🏼‍♂",
			"🧏🏽‍♂️",
			"🧏🏽‍♂",
			"🧏🏾‍♂️",
			"🧏🏾‍♂",
			"🧏🏿‍♂️",
			"🧏🏿‍♂",
			"🧏‍♀️",
			"🧏‍♀",
			"🧏🏻‍♀️",
			"🧏🏻‍♀",
			"🧏🏼‍♀️",
			"🧏🏼‍♀",
			"🧏🏽‍♀️",
			"🧏🏽‍♀",
			"🧏🏾‍♀️",
			"🧏🏾‍♀",
			"🧏🏿‍♀️",
			"🧏🏿‍♀",
			"🙇",
			"🙇🏻",
			"🙇🏼",
			"🙇🏽",
			"🙇🏾",
			"🙇🏿",
			"🙇‍♂️",
			"🙇‍♂",
			"🙇🏻‍♂️",
			"🙇🏻‍♂",
			"🙇🏼‍♂️",
			"🙇🏼‍♂",
			"🙇🏽‍♂️",
			"🙇🏽‍♂",
			"🙇🏾‍♂️",
			"🙇🏾‍♂",
			"🙇🏿‍♂️",
			"🙇🏿‍♂",
			"🙇‍♀️",
			"🙇‍♀",
			"🙇🏻‍♀️",
			"🙇🏻‍♀",
			"🙇🏼‍♀️",
			"🙇🏼‍♀",
			"🙇🏽‍♀️",
			"🙇🏽‍♀",
			"🙇🏾‍♀️",
			"🙇🏾‍♀",
			"🙇🏿‍♀️",
			"🙇🏿‍♀",
			"🤦",
			"🤦🏻",
			"🤦🏼",
			"🤦🏽",
			"🤦🏾",
			"🤦🏿",
			"🤦‍♂️",
			"🤦‍♂",
			"🤦🏻‍♂️",
			"🤦🏻‍♂",
			"🤦🏼‍♂️",
			"🤦🏼‍♂",
			"🤦🏽‍♂️",
			"🤦🏽‍♂",
			"🤦🏾‍♂️",
			"🤦🏾‍♂",
			"🤦🏿‍♂️",
			"🤦🏿‍♂",
			"🤦‍♀️",
			"🤦‍♀",
			"🤦🏻‍♀️",
			"🤦🏻‍♀",
			"🤦🏼‍♀️",
			"🤦🏼‍♀",
			"🤦🏽‍♀️",
			"🤦🏽‍♀",
			"🤦🏾‍♀️",
			"🤦🏾‍♀",
			"🤦🏿‍♀️",
			"🤦🏿‍♀",
			"🤷",
			"🤷🏻",
			"🤷🏼",
			"🤷🏽",
			"🤷🏾",
			"🤷🏿",
			"🤷‍♂️",
			"🤷‍♂",
			"🤷🏻‍♂️",
			"🤷🏻‍♂",
			"🤷🏼‍♂️",
			"🤷🏼‍♂",
			"🤷🏽‍♂️",
			"🤷🏽‍♂",
			"🤷🏾‍♂️",
			"🤷🏾‍♂",
			"🤷🏿‍♂️",
			"🤷🏿‍♂",
			"🤷‍♀️",
			"🤷‍♀",
			"🤷🏻‍♀️",
			"🤷🏻‍♀",
			"🤷🏼‍♀️",
			"🤷🏼‍♀",
			"🤷🏽‍♀️",
			"🤷🏽‍♀",
			"🤷🏾‍♀️",
			"🤷🏾‍♀",
			"🤷🏿‍♀️",
			"🤷🏿‍♀",
			"🧑‍⚕️",
			"🧑‍⚕",
			"🧑🏻‍⚕️",
			"🧑🏻‍⚕",
			"🧑🏼‍⚕️",
			"🧑🏼‍⚕",
			"🧑🏽‍⚕️",
			"🧑🏽‍⚕",
			"🧑🏾‍⚕️",
			"🧑🏾‍⚕",
			"🧑🏿‍⚕️",
			"🧑🏿‍⚕",
			"👨‍⚕️",
			"👨‍⚕",
			"👨🏻‍⚕️",
			"👨🏻‍⚕",
			"👨🏼‍⚕️",
			"👨🏼‍⚕",
			"👨🏽‍⚕️",
			"👨🏽‍⚕",
			"👨🏾‍⚕️",
			"👨🏾‍⚕",
			"👨🏿‍⚕️",
			"👨🏿‍⚕",
			"👩‍⚕️",
			"👩‍⚕",
			"👩🏻‍⚕️",
			"👩🏻‍⚕",
			"👩🏼‍⚕️",
			"👩🏼‍⚕",
			"👩🏽‍⚕️",
			"👩🏽‍⚕",
			"👩🏾‍⚕️",
			"👩🏾‍⚕",
			"👩🏿‍⚕️",
			"👩🏿‍⚕",
			"🧑‍🎓",
			"🧑🏻‍🎓",
			"🧑🏼‍🎓",
			"🧑🏽‍🎓",
			"🧑🏾‍🎓",
			"🧑🏿‍🎓",
			"👨‍🎓",
			"👨🏻‍🎓",
			"👨🏼‍🎓",
			"👨🏽‍🎓",
			"👨🏾‍🎓",
			"👨🏿‍🎓",
			"👩‍🎓",
			"👩🏻‍🎓",
			"👩🏼‍🎓",
			"👩🏽‍🎓",
			"👩🏾‍🎓",
			"👩🏿‍🎓",
			"🧑‍🏫",
			"🧑🏻‍🏫",
			"🧑🏼‍🏫",
			"🧑🏽‍🏫",
			"🧑🏾‍🏫",
			"🧑🏿‍🏫",
			"👨‍🏫",
			"👨🏻‍🏫",
			"👨🏼‍🏫",
			"👨🏽‍🏫",
			"👨🏾‍🏫",
			"👨🏿‍🏫",
			"👩‍🏫",
			"👩🏻‍🏫",
			"👩🏼‍🏫",
			"👩🏽‍🏫",
			"👩🏾‍🏫",
			"👩🏿‍🏫",
			"🧑‍⚖️",
			"🧑‍⚖",
			"🧑🏻‍⚖️",
			"🧑🏻‍⚖",
			"🧑🏼‍⚖️",
			"🧑🏼‍⚖",
			"🧑🏽‍⚖️",
			"🧑🏽‍⚖",
			"🧑🏾‍⚖️",
			"🧑🏾‍⚖",
			"🧑🏿‍⚖️",
			"🧑🏿‍⚖",
			"👨‍⚖️",
			"👨‍⚖",
			"👨🏻‍⚖️",
			"👨🏻‍⚖",
			"👨🏼‍⚖️",
			"👨🏼‍⚖",
			"👨🏽‍⚖️",
			"👨🏽‍⚖",
			"👨🏾‍⚖️",
			"👨🏾‍⚖",
			"👨🏿‍⚖️",
			"👨🏿‍⚖",
			"👩‍⚖️",
			"👩‍⚖",
			"👩🏻‍⚖️",
			"👩🏻‍⚖",
			"👩🏼‍⚖️",
			"👩🏼‍⚖",
			"👩🏽‍⚖️",
			"👩🏽‍⚖",
			"👩🏾‍⚖️",
			"👩🏾‍⚖",
			"👩🏿‍⚖️",
			"👩🏿‍⚖",
			"🧑‍🌾",
			"🧑🏻‍🌾",
			"🧑🏼‍🌾",
			"🧑🏽‍🌾",
			"🧑🏾‍🌾",
			"🧑🏿‍🌾",
			"👨‍🌾",
			"👨🏻‍🌾",
			"👨🏼‍🌾",
			"👨🏽‍🌾",
			"👨🏾‍🌾",
			"👨🏿‍🌾",
			"👩‍🌾",
			"👩🏻‍🌾",
			"👩🏼‍🌾",
			"👩🏽‍🌾",
			"👩🏾‍🌾",
			"👩🏿‍🌾",
			"🧑‍🍳",
			"🧑🏻‍🍳",
			"🧑🏼‍🍳",
			"🧑🏽‍🍳",
			"🧑🏾‍🍳",
			"🧑🏿‍🍳",
			"👨‍🍳",
			"👨🏻‍🍳",
			"👨🏼‍🍳",
			"👨🏽‍🍳",
			"👨🏾‍🍳",
			"👨🏿‍🍳",
			"👩‍🍳",
			"👩🏻‍🍳",
			"👩🏼‍🍳",
			"👩🏽‍🍳",
			"👩🏾‍🍳",
			"👩🏿‍🍳",
			"🧑‍🔧",
			"🧑🏻‍🔧",
			"🧑🏼‍🔧",
			"🧑🏽‍🔧",
			"🧑🏾‍🔧",
			"🧑🏿‍🔧",
			"👨‍🔧",
			"👨🏻‍🔧",
			"👨🏼‍🔧",
			"👨🏽‍🔧",
			"👨🏾‍🔧",
			"👨🏿‍🔧",
			"👩‍🔧",
			"👩🏻‍🔧",
			"👩🏼‍🔧",
			"👩🏽‍🔧",
			"👩🏾‍🔧",
			"👩🏿‍🔧",
			"🧑‍🏭",
			"🧑🏻‍🏭",
			"🧑🏼‍🏭",
			"🧑🏽‍🏭",
			"🧑🏾‍🏭",
			"🧑🏿‍🏭",
			"👨‍🏭",
			"👨🏻‍🏭",
			"👨🏼‍🏭",
			"👨🏽‍🏭",
			"👨🏾‍🏭",
			"👨🏿‍🏭",
			"👩‍🏭",
			"👩🏻‍🏭",
			"👩🏼‍🏭",
			"👩🏽‍🏭",
			"👩🏾‍🏭",
			"👩🏿‍🏭",
			"🧑‍💼",
			"🧑🏻‍💼",
			"🧑🏼‍💼",
			"🧑🏽‍💼",
			"🧑🏾‍💼",
			"🧑🏿‍💼",
			"👨‍💼",
			"👨🏻‍💼",
			"👨🏼‍💼",
			"👨🏽‍💼",
			"👨🏾‍💼",
			"👨🏿‍💼",
			"👩‍💼",
			"👩🏻‍💼",
			"👩🏼‍💼",
			"👩🏽‍💼",
			"👩🏾‍💼",
			"👩🏿‍💼",
			"🧑‍🔬",
			"🧑🏻‍🔬",
			"🧑🏼‍🔬",
			"🧑🏽‍🔬",
			"🧑🏾‍🔬",
			"🧑🏿‍🔬",
			"👨‍🔬",
			"👨🏻‍🔬",
			"👨🏼‍🔬",
			"👨🏽‍🔬",
			"👨🏾‍🔬",
			"👨🏿‍🔬",
			"👩‍🔬",
			"👩🏻‍🔬",
			"👩🏼‍🔬",
			"👩🏽‍🔬",
			"👩🏾‍🔬",
			"👩🏿‍🔬",
			"🧑‍💻",
			"🧑🏻‍💻",
			"🧑🏼‍💻",
			"🧑🏽‍💻",
			"🧑🏾‍💻",
			"🧑🏿‍💻",
			"👨‍💻",
			"👨🏻‍💻",
			"👨🏼‍💻",
			"👨🏽‍💻",
			"👨🏾‍💻",
			"👨🏿‍💻",
			"👩‍💻",
			"👩🏻‍💻",
			"👩🏼‍💻",
			"👩🏽‍💻",
			"👩🏾‍💻",
			"👩🏿‍💻",
			"🧑‍🎤",
			"🧑🏻‍🎤",
			"🧑🏼‍🎤",
			"🧑🏽‍🎤",
			"🧑🏾‍🎤",
			"🧑🏿‍🎤",
			"👨‍🎤",
			"👨🏻‍🎤",
			"👨🏼‍🎤",
			"👨🏽‍🎤",
			"👨🏾‍🎤",
			"👨🏿‍🎤",
			"👩‍🎤",
			"👩🏻‍🎤",
			"👩🏼‍🎤",
			"👩🏽‍🎤",
			"👩🏾‍🎤",
			"👩🏿‍🎤",
			"🧑‍🎨",
			"🧑🏻‍🎨",
			"🧑🏼‍🎨",
			"🧑🏽‍🎨",
			"🧑🏾‍🎨",
			"🧑🏿‍🎨",
			"👨‍🎨",
			"👨🏻‍🎨",
			"👨🏼‍🎨",
			"👨🏽‍🎨",
			"👨🏾‍🎨",
			"👨🏿‍🎨",
			"👩‍🎨",
			"👩🏻‍🎨",
			"👩🏼‍🎨",
			"👩🏽‍🎨",
			"👩🏾‍🎨",
			"👩🏿‍🎨",
			"🧑‍✈️",
			"🧑‍✈",
			"🧑🏻‍✈️",
			"🧑🏻‍✈",
			"🧑🏼‍✈️",
			"🧑🏼‍✈",
			"🧑🏽‍✈️",
			"🧑🏽‍✈",
			"🧑🏾‍✈️",
			"🧑🏾‍✈",
			"🧑🏿‍✈️",
			"🧑🏿‍✈",
			"👨‍✈️",
			"👨‍✈",
			"👨🏻‍✈️",
			"👨🏻‍✈",
			"👨🏼‍✈️",
			"👨🏼‍✈",
			"👨🏽‍✈️",
			"👨🏽‍✈",
			"👨🏾‍✈️",
			"👨🏾‍✈",
			"👨🏿‍✈️",
			"👨🏿‍✈",
			"👩‍✈️",
			"👩‍✈",
			"👩🏻‍✈️",
			"👩🏻‍✈",
			"👩🏼‍✈️",
			"👩🏼‍✈",
			"👩🏽‍✈️",
			"👩🏽‍✈",
			"👩🏾‍✈️",
			"👩🏾‍✈",
			"👩🏿‍✈️",
			"👩🏿‍✈",
			"🧑‍🚀",
			"🧑🏻‍🚀",
			"🧑🏼‍🚀",
			"🧑🏽‍🚀",
			"🧑🏾‍🚀",
			"🧑🏿‍🚀",
			"👨‍🚀",
			"👨🏻‍🚀",
			"👨🏼‍🚀",
			"👨🏽‍🚀",
			"👨🏾‍🚀",
			"👨🏿‍🚀",
			"👩‍🚀",
			"👩🏻‍🚀",
			"👩🏼‍🚀",
			"👩🏽‍🚀",
			"👩🏾‍🚀",
			"👩🏿‍🚀",
			"🧑‍🚒",
			"🧑🏻‍🚒",
			"🧑🏼‍🚒",
			"🧑🏽‍🚒",
			"🧑🏾‍🚒",
			"🧑🏿‍🚒",
			"👨‍🚒",
			"👨🏻‍🚒",
			"👨🏼‍🚒",
			"👨🏽‍🚒",
			"👨🏾‍🚒",
			"👨🏿‍🚒",
			"👩‍🚒",
			"👩🏻‍🚒",
			"👩🏼‍🚒",
			"👩🏽‍🚒",
			"👩🏾‍🚒",
			"👩🏿‍🚒",
			"👮",
			"👮🏻",
			"👮🏼",
			"👮🏽",
			"👮🏾",
			"👮🏿",
			"👮‍♂️",
			"👮‍♂",
			"👮🏻‍♂️",
			"👮🏻‍♂",
			"👮🏼‍♂️",
			"👮🏼‍♂",
			"👮🏽‍♂️",
			"👮🏽‍♂",
			"👮🏾‍♂️",
			"👮🏾‍♂",
			"👮🏿‍♂️",
			"👮🏿‍♂",
			"👮‍♀️",
			"👮‍♀",
			"👮🏻‍♀️",
			"👮🏻‍♀",
			"👮🏼‍♀️",
			"👮🏼‍♀",
			"👮🏽‍♀️",
			"👮🏽‍♀",
			"👮🏾‍♀️",
			"👮🏾‍♀",
			"👮🏿‍♀️",
			"👮🏿‍♀",
			"🕵️",
			"🕵",
			"🕵🏻",
			"🕵🏼",
			"🕵🏽",
			"🕵🏾",
			"🕵🏿",
			"🕵️‍♂️",
			"🕵‍♂️",
			"🕵️‍♂",
			"🕵‍♂",
			"🕵🏻‍♂️",
			"🕵🏻‍♂",
			"🕵🏼‍♂️",
			"🕵🏼‍♂",
			"🕵🏽‍♂️",
			"🕵🏽‍♂",
			"🕵🏾‍♂️",
			"🕵🏾‍♂",
			"🕵🏿‍♂️",
			"🕵🏿‍♂",
			"🕵️‍♀️",
			"🕵‍♀️",
			"🕵️‍♀",
			"🕵‍♀",
			"🕵🏻‍♀️",
			"🕵🏻‍♀",
			"🕵🏼‍♀️",
			"🕵🏼‍♀",
			"🕵🏽‍♀️",
			"🕵🏽‍♀",
			"🕵🏾‍♀️",
			"🕵🏾‍♀",
			"🕵🏿‍♀️",
			"🕵🏿‍♀",
			"💂",
			"💂🏻",
			"💂🏼",
			"💂🏽",
			"💂🏾",
			"💂🏿",
			"💂‍♂️",
			"💂‍♂",
			"💂🏻‍♂️",
			"💂🏻‍♂",
			"💂🏼‍♂️",
			"💂🏼‍♂",
			"💂🏽‍♂️",
			"💂🏽‍♂",
			"💂🏾‍♂️",
			"💂🏾‍♂",
			"💂🏿‍♂️",
			"💂🏿‍♂",
			"💂‍♀️",
			"💂‍♀",
			"💂🏻‍♀️",
			"💂🏻‍♀",
			"💂🏼‍♀️",
			"💂🏼‍♀",
			"💂🏽‍♀️",
			"💂🏽‍♀",
			"💂🏾‍♀️",
			"💂🏾‍♀",
			"💂🏿‍♀️",
			"💂🏿‍♀",
			"🥷",
			"🥷🏻",
			"🥷🏼",
			"🥷🏽",
			"🥷🏾",
			"🥷🏿",
			"👷",
			"👷🏻",
			"👷🏼",
			"👷🏽",
			"👷🏾",
			"👷🏿",
			"👷‍♂️",
			"👷‍♂",
			"👷🏻‍♂️",
			"👷🏻‍♂",
			"👷🏼‍♂️",
			"👷🏼‍♂",
			"👷🏽‍♂️",
			"👷🏽‍♂",
			"👷🏾‍♂️",
			"👷🏾‍♂",
			"👷🏿‍♂️",
			"👷🏿‍♂",
			"👷‍♀️",
			"👷‍♀",
			"👷🏻‍♀️",
			"👷🏻‍♀",
			"👷🏼‍♀️",
			"👷🏼‍♀",
			"👷🏽‍♀️",
			"👷🏽‍♀",
			"👷🏾‍♀️",
			"👷🏾‍♀",
			"👷🏿‍♀️",
			"👷🏿‍♀",
			"🤴",
			"🤴🏻",
			"🤴🏼",
			"🤴🏽",
			"🤴🏾",
			"🤴🏿",
			"👸",
			"👸🏻",
			"👸🏼",
			"👸🏽",
			"👸🏾",
			"👸🏿",
			"👳",
			"👳🏻",
			"👳🏼",
			"👳🏽",
			"👳🏾",
			"👳🏿",
			"👳‍♂️",
			"👳‍♂",
			"👳🏻‍♂️",
			"👳🏻‍♂",
			"👳🏼‍♂️",
			"👳🏼‍♂",
			"👳🏽‍♂️",
			"👳🏽‍♂",
			"👳🏾‍♂️",
			"👳🏾‍♂",
			"👳🏿‍♂️",
			"👳🏿‍♂",
			"👳‍♀️",
			"👳‍♀",
			"👳🏻‍♀️",
			"👳🏻‍♀",
			"👳🏼‍♀️",
			"👳🏼‍♀",
			"👳🏽‍♀️",
			"👳🏽‍♀",
			"👳🏾‍♀️",
			"👳🏾‍♀",
			"👳🏿‍♀️",
			"👳🏿‍♀",
			"👲",
			"👲🏻",
			"👲🏼",
			"👲🏽",
			"👲🏾",
			"👲🏿",
			"🧕",
			"🧕🏻",
			"🧕🏼",
			"🧕🏽",
			"🧕🏾",
			"🧕🏿",
			"🤵",
			"🤵🏻",
			"🤵🏼",
			"🤵🏽",
			"🤵🏾",
			"🤵🏿",
			"🤵‍♂️",
			"🤵‍♂",
			"🤵🏻‍♂️",
			"🤵🏻‍♂",
			"🤵🏼‍♂️",
			"🤵🏼‍♂",
			"🤵🏽‍♂️",
			"🤵🏽‍♂",
			"🤵🏾‍♂️",
			"🤵🏾‍♂",
			"🤵🏿‍♂️",
			"🤵🏿‍♂",
			"🤵‍♀️",
			"🤵‍♀",
			"🤵🏻‍♀️",
			"🤵🏻‍♀",
			"🤵🏼‍♀️",
			"🤵🏼‍♀",
			"🤵🏽‍♀️",
			"🤵🏽‍♀",
			"🤵🏾‍♀️",
			"🤵🏾‍♀",
			"🤵🏿‍♀️",
			"🤵🏿‍♀",
			"👰",
			"👰🏻",
			"👰🏼",
			"👰🏽",
			"👰🏾",
			"👰🏿",
			"👰‍♂️",
			"👰‍♂",
			"👰🏻‍♂️",
			"👰🏻‍♂",
			"👰🏼‍♂️",
			"👰🏼‍♂",
			"👰🏽‍♂️",
			"👰🏽‍♂",
			"👰🏾‍♂️",
			"👰🏾‍♂",
			"👰🏿‍♂️",
			"👰🏿‍♂",
			"👰‍♀️",
			"👰‍♀",
			"👰🏻‍♀️",
			"👰🏻‍♀",
			"👰🏼‍♀️",
			"👰🏼‍♀",
			"👰🏽‍♀️",
			"👰🏽‍♀",
			"👰🏾‍♀️",
			"👰🏾‍♀",
			"👰🏿‍♀️",
			"👰🏿‍♀",
			"🤰",
			"🤰🏻",
			"🤰🏼",
			"🤰🏽",
			"🤰🏾",
			"🤰🏿",
			"🤱",
			"🤱🏻",
			"🤱🏼",
			"🤱🏽",
			"🤱🏾",
			"🤱🏿",
			"👩‍🍼",
			"👩🏻‍🍼",
			"👩🏼‍🍼",
			"👩🏽‍🍼",
			"👩🏾‍🍼",
			"👩🏿‍🍼",
			"👨‍🍼",
			"👨🏻‍🍼",
			"👨🏼‍🍼",
			"👨🏽‍🍼",
			"👨🏾‍🍼",
			"👨🏿‍🍼",
			"🧑‍🍼",
			"🧑🏻‍🍼",
			"🧑🏼‍🍼",
			"🧑🏽‍🍼",
			"🧑🏾‍🍼",
			"🧑🏿‍🍼",
			"👼",
			"👼🏻",
			"👼🏼",
			"👼🏽",
			"👼🏾",
			"👼🏿",
			"🎅",
			"🎅🏻",
			"🎅🏼",
			"🎅🏽",
			"🎅🏾",
			"🎅🏿",
			"🤶",
			"🤶🏻",
			"🤶🏼",
			"🤶🏽",
			"🤶🏾",
			"🤶🏿",
			"🧑‍🎄",
			"🧑🏻‍🎄",
			"🧑🏼‍🎄",
			"🧑🏽‍🎄",
			"🧑🏾‍🎄",
			"🧑🏿‍🎄",
			"🦸",
			"🦸🏻",
			"🦸🏼",
			"🦸🏽",
			"🦸🏾",
			"🦸🏿",
			"🦸‍♂️",
			"🦸‍♂",
			"🦸🏻‍♂️",
			"🦸🏻‍♂",
			"🦸🏼‍♂️",
			"🦸🏼‍♂",
			"🦸🏽‍♂️",
			"🦸🏽‍♂",
			"🦸🏾‍♂️",
			"🦸🏾‍♂",
			"🦸🏿‍♂️",
			"🦸🏿‍♂",
			"🦸‍♀️",
			"🦸‍♀",
			"🦸🏻‍♀️",
			"🦸🏻‍♀",
			"🦸🏼‍♀️",
			"🦸🏼‍♀",
			"🦸🏽‍♀️",
			"🦸🏽‍♀",
			"🦸🏾‍♀️",
			"🦸🏾‍♀",
			"🦸🏿‍♀️",
			"🦸🏿‍♀",
			"🦹",
			"🦹🏻",
			"🦹🏼",
			"🦹🏽",
			"🦹🏾",
			"🦹🏿",
			"🦹‍♂️",
			"🦹‍♂",
			"🦹🏻‍♂️",
			"🦹🏻‍♂",
			"🦹🏼‍♂️",
			"🦹🏼‍♂",
			"🦹🏽‍♂️",
			"🦹🏽‍♂",
			"🦹🏾‍♂️",
			"🦹🏾‍♂",
			"🦹🏿‍♂️",
			"🦹🏿‍♂",
			"🦹‍♀️",
			"🦹‍♀",
			"🦹🏻‍♀️",
			"🦹🏻‍♀",
			"🦹🏼‍♀️",
			"🦹🏼‍♀",
			"🦹🏽‍♀️",
			"🦹🏽‍♀",
			"🦹🏾‍♀️",
			"🦹🏾‍♀",
			"🦹🏿‍♀️",
			"🦹🏿‍♀",
			"🧙",
			"🧙🏻",
			"🧙🏼",
			"🧙🏽",
			"🧙🏾",
			"🧙🏿",
			"🧙‍♂️",
			"🧙‍♂",
			"🧙🏻‍♂️",
			"🧙🏻‍♂",
			"🧙🏼‍♂️",
			"🧙🏼‍♂",
			"🧙🏽‍♂️",
			"🧙🏽‍♂",
			"🧙🏾‍♂️",
			"🧙🏾‍♂",
			"🧙🏿‍♂️",
			"🧙🏿‍♂",
			"🧙‍♀️",
			"🧙‍♀",
			"🧙🏻‍♀️",
			"🧙🏻‍♀",
			"🧙🏼‍♀️",
			"🧙🏼‍♀",
			"🧙🏽‍♀️",
			"🧙🏽‍♀",
			"🧙🏾‍♀️",
			"🧙🏾‍♀",
			"🧙🏿‍♀️",
			"🧙🏿‍♀",
			"🧚",
			"🧚🏻",
			"🧚🏼",
			"🧚🏽",
			"🧚🏾",
			"🧚🏿",
			"🧚‍♂️",
			"🧚‍♂",
			"🧚🏻‍♂️",
			"🧚🏻‍♂",
			"🧚🏼‍♂️",
			"🧚🏼‍♂",
			"🧚🏽‍♂️",
			"🧚🏽‍♂",
			"🧚🏾‍♂️",
			"🧚🏾‍♂",
			"🧚🏿‍♂️",
			"🧚🏿‍♂",
			"🧚‍♀️",
			"🧚‍♀",
			"🧚🏻‍♀️",
			"🧚🏻‍♀",
			"🧚🏼‍♀️",
			"🧚🏼‍♀",
			"🧚🏽‍♀️",
			"🧚🏽‍♀",
			"🧚🏾‍♀️",
			"🧚🏾‍♀",
			"🧚🏿‍♀️",
			"🧚🏿‍♀",
			"🧛",
			"🧛🏻",
			"🧛🏼",
			"🧛🏽",
			"🧛🏾",
			"🧛🏿",
			"🧛‍♂️",
			"🧛‍♂",
			"🧛🏻‍♂️",
			"🧛🏻‍♂",
			"🧛🏼‍♂️",
			"🧛🏼‍♂",
			"🧛🏽‍♂️",
			"🧛🏽‍♂",
			"🧛🏾‍♂️",
			"🧛🏾‍♂",
			"🧛🏿‍♂️",
			"🧛🏿‍♂",
			"🧛‍♀️",
			"🧛‍♀",
			"🧛🏻‍♀️",
			"🧛🏻‍♀",
			"🧛🏼‍♀️",
			"🧛🏼‍♀",
			"🧛🏽‍♀️",
			"🧛🏽‍♀",
			"🧛🏾‍♀️",
			"🧛🏾‍♀",
			"🧛🏿‍♀️",
			"🧛🏿‍♀",
			"🧜",
			"🧜🏻",
			"🧜🏼",
			"🧜🏽",
			"🧜🏾",
			"🧜🏿",
			"🧜‍♂️",
			"🧜‍♂",
			"🧜🏻‍♂️",
			"🧜🏻‍♂",
			"🧜🏼‍♂️",
			"🧜🏼‍♂",
			"🧜🏽‍♂️",
			"🧜🏽‍♂",
			"🧜🏾‍♂️",
			"🧜🏾‍♂",
			"🧜🏿‍♂️",
			"🧜🏿‍♂",
			"🧜‍♀️",
			"🧜‍♀",
			"🧜🏻‍♀️",
			"🧜🏻‍♀",
			"🧜🏼‍♀️",
			"🧜🏼‍♀",
			"🧜🏽‍♀️",
			"🧜🏽‍♀",
			"🧜🏾‍♀️",
			"🧜🏾‍♀",
			"🧜🏿‍♀️",
			"🧜🏿‍♀",
			"🧝",
			"🧝🏻",
			"🧝🏼",
			"🧝🏽",
			"🧝🏾",
			"🧝🏿",
			"🧝‍♂️",
			"🧝‍♂",
			"🧝🏻‍♂️",
			"🧝🏻‍♂",
			"🧝🏼‍♂️",
			"🧝🏼‍♂",
			"🧝🏽‍♂️",
			"🧝🏽‍♂",
			"🧝🏾‍♂️",
			"🧝🏾‍♂",
			"🧝🏿‍♂️",
			"🧝🏿‍♂",
			"🧝‍♀️",
			"🧝‍♀",
			"🧝🏻‍♀️",
			"🧝🏻‍♀",
			"🧝🏼‍♀️",
			"🧝🏼‍♀",
			"🧝🏽‍♀️",
			"🧝🏽‍♀",
			"🧝🏾‍♀️",
			"🧝🏾‍♀",
			"🧝🏿‍♀️",
			"🧝🏿‍♀",
			"🧞",
			"🧞‍♂️",
			"🧞‍♂",
			"🧞‍♀️",
			"🧞‍♀",
			"🧟",
			"🧟‍♂️",
			"🧟‍♂",
			"🧟‍♀️",
			"🧟‍♀",
			"💆",
			"💆🏻",
			"💆🏼",
			"💆🏽",
			"💆🏾",
			"💆🏿",
			"💆‍♂️",
			"💆‍♂",
			"💆🏻‍♂️",
			"💆🏻‍♂",
			"💆🏼‍♂️",
			"💆🏼‍♂",
			"💆🏽‍♂️",
			"💆🏽‍♂",
			"💆🏾‍♂️",
			"💆🏾‍♂",
			"💆🏿‍♂️",
			"💆🏿‍♂",
			"💆‍♀️",
			"💆‍♀",
			"💆🏻‍♀️",
			"💆🏻‍♀",
			"💆🏼‍♀️",
			"💆🏼‍♀",
			"💆🏽‍♀️",
			"💆🏽‍♀",
			"💆🏾‍♀️",
			"💆🏾‍♀",
			"💆🏿‍♀️",
			"💆🏿‍♀",
			"💇",
			"💇🏻",
			"💇🏼",
			"💇🏽",
			"💇🏾",
			"💇🏿",
			"💇‍♂️",
			"💇‍♂",
			"💇🏻‍♂️",
			"💇🏻‍♂",
			"💇🏼‍♂️",
			"💇🏼‍♂",
			"💇🏽‍♂️",
			"💇🏽‍♂",
			"💇🏾‍♂️",
			"💇🏾‍♂",
			"💇🏿‍♂️",
			"💇🏿‍♂",
			"💇‍♀️",
			"💇‍♀",
			"💇🏻‍♀️",
			"💇🏻‍♀",
			"💇🏼‍♀️",
			"💇🏼‍♀",
			"💇🏽‍♀️",
			"💇🏽‍♀",
			"💇🏾‍♀️",
			"💇🏾‍♀",
			"💇🏿‍♀️",
			"💇🏿‍♀",
			"🚶",
			"🚶🏻",
			"🚶🏼",
			"🚶🏽",
			"🚶🏾",
			"🚶🏿",
			"🚶‍♂️",
			"🚶‍♂",
			"🚶🏻‍♂️",
			"🚶🏻‍♂",
			"🚶🏼‍♂️",
			"🚶🏼‍♂",
			"🚶🏽‍♂️",
			"🚶🏽‍♂",
			"🚶🏾‍♂️",
			"🚶🏾‍♂",
			"🚶🏿‍♂️",
			"🚶🏿‍♂",
			"🚶‍♀️",
			"🚶‍♀",
			"🚶🏻‍♀️",
			"🚶🏻‍♀",
			"🚶🏼‍♀️",
			"🚶🏼‍♀",
			"🚶🏽‍♀️",
			"🚶🏽‍♀",
			"🚶🏾‍♀️",
			"🚶🏾‍♀",
			"🚶🏿‍♀️",
			"🚶🏿‍♀",
			"🧍",
			"🧍🏻",
			"🧍🏼",
			"🧍🏽",
			"🧍🏾",
			"🧍🏿",
			"🧍‍♂️",
			"🧍‍♂",
			"🧍🏻‍♂️",
			"🧍🏻‍♂",
			"🧍🏼‍♂️",
			"🧍🏼‍♂",
			"🧍🏽‍♂️",
			"🧍🏽‍♂",
			"🧍🏾‍♂️",
			"🧍🏾‍♂",
			"🧍🏿‍♂️",
			"🧍🏿‍♂",
			"🧍‍♀️",
			"🧍‍♀",
			"🧍🏻‍♀️",
			"🧍🏻‍♀",
			"🧍🏼‍♀️",
			"🧍🏼‍♀",
			"🧍🏽‍♀️",
			"🧍🏽‍♀",
			"🧍🏾‍♀️",
			"🧍🏾‍♀",
			"🧍🏿‍♀️",
			"🧍🏿‍♀",
			"🧎",
			"🧎🏻",
			"🧎🏼",
			"🧎🏽",
			"🧎🏾",
			"🧎🏿",
			"🧎‍♂️",
			"🧎‍♂",
			"🧎🏻‍♂️",
			"🧎🏻‍♂",
			"🧎🏼‍♂️",
			"🧎🏼‍♂",
			"🧎🏽‍♂️",
			"🧎🏽‍♂",
			"🧎🏾‍♂️",
			"🧎🏾‍♂",
			"🧎🏿‍♂️",
			"🧎🏿‍♂",
			"🧎‍♀️",
			"🧎‍♀",
			"🧎🏻‍♀️",
			"🧎🏻‍♀",
			"🧎🏼‍♀️",
			"🧎🏼‍♀",
			"🧎🏽‍♀️",
			"🧎🏽‍♀",
			"🧎🏾‍♀️",
			"🧎🏾‍♀",
			"🧎🏿‍♀️",
			"🧎🏿‍♀",
			"🧑‍🦯",
			"🧑🏻‍🦯",
			"🧑🏼‍🦯",
			"🧑🏽‍🦯",
			"🧑🏾‍🦯",
			"🧑🏿‍🦯",
			"👨‍🦯",
			"👨🏻‍🦯",
			"👨🏼‍🦯",
			"👨🏽‍🦯",
			"👨🏾‍🦯",
			"👨🏿‍🦯",
			"👩‍🦯",
			"👩🏻‍🦯",
			"👩🏼‍🦯",
			"👩🏽‍🦯",
			"👩🏾‍🦯",
			"👩🏿‍🦯",
			"🧑‍🦼",
			"🧑🏻‍🦼",
			"🧑🏼‍🦼",
			"🧑🏽‍🦼",
			"🧑🏾‍🦼",
			"🧑🏿‍🦼",
			"👨‍🦼",
			"👨🏻‍🦼",
			"👨🏼‍🦼",
			"👨🏽‍🦼",
			"👨🏾‍🦼",
			"👨🏿‍🦼",
			"👩‍🦼",
			"👩🏻‍🦼",
			"👩🏼‍🦼",
			"👩🏽‍🦼",
			"👩🏾‍🦼",
			"👩🏿‍🦼",
			"🧑‍🦽",
			"🧑🏻‍🦽",
			"🧑🏼‍🦽",
			"🧑🏽‍🦽",
			"🧑🏾‍🦽",
			"🧑🏿‍🦽",
			"👨‍🦽",
			"👨🏻‍🦽",
			"👨🏼‍🦽",
			"👨🏽‍🦽",
			"👨🏾‍🦽",
			"👨🏿‍🦽",
			"👩‍🦽",
			"👩🏻‍🦽",
			"👩🏼‍🦽",
			"👩🏽‍🦽",
			"👩🏾‍🦽",
			"👩🏿‍🦽",
			"🏃",
			"🏃🏻",
			"🏃🏼",
			"🏃🏽",
			"🏃🏾",
			"🏃🏿",
			"🏃‍♂️",
			"🏃‍♂",
			"🏃🏻‍♂️",
			"🏃🏻‍♂",
			"🏃🏼‍♂️",
			"🏃🏼‍♂",
			"🏃🏽‍♂️",
			"🏃🏽‍♂",
			"🏃🏾‍♂️",
			"🏃🏾‍♂",
			"🏃🏿‍♂️",
			"🏃🏿‍♂",
			"🏃‍♀️",
			"🏃‍♀",
			"🏃🏻‍♀️",
			"🏃🏻‍♀",
			"🏃🏼‍♀️",
			"🏃🏼‍♀",
			"🏃🏽‍♀️",
			"🏃🏽‍♀",
			"🏃🏾‍♀️",
			"🏃🏾‍♀",
			"🏃🏿‍♀️",
			"🏃🏿‍♀",
			"💃",
			"💃🏻",
			"💃🏼",
			"💃🏽",
			"💃🏾",
			"💃🏿",
			"🕺",
			"🕺🏻",
			"🕺🏼",
			"🕺🏽",
			"🕺🏾",
			"🕺🏿",
			"🕴️",
			"🕴",
			"🕴🏻",
			"🕴🏼",
			"🕴🏽",
			"🕴🏾",
			"🕴🏿",
			"👯",
			"👯‍♂️",
			"👯‍♂",
			"👯‍♀️",
			"👯‍♀",
			"🧖",
			"🧖🏻",
			"🧖🏼",
			"🧖🏽",
			"🧖🏾",
			"🧖🏿",
			"🧖‍♂️",
			"🧖‍♂",
			"🧖🏻‍♂️",
			"🧖🏻‍♂",
			"🧖🏼‍♂️",
			"🧖🏼‍♂",
			"🧖🏽‍♂️",
			"🧖🏽‍♂",
			"🧖🏾‍♂️",
			"🧖🏾‍♂",
			"🧖🏿‍♂️",
			"🧖🏿‍♂",
			"🧖‍♀️",
			"🧖‍♀",
			"🧖🏻‍♀️",
			"🧖🏻‍♀",
			"🧖🏼‍♀️",
			"🧖🏼‍♀",
			"🧖🏽‍♀️",
			"🧖🏽‍♀",
			"🧖🏾‍♀️",
			"🧖🏾‍♀",
			"🧖🏿‍♀️",
			"🧖🏿‍♀",
			"🧗",
			"🧗🏻",
			"🧗🏼",
			"🧗🏽",
			"🧗🏾",
			"🧗🏿",
			"🧗‍♂️",
			"🧗‍♂",
			"🧗🏻‍♂️",
			"🧗🏻‍♂",
			"🧗🏼‍♂️",
			"🧗🏼‍♂",
			"🧗🏽‍♂️",
			"🧗🏽‍♂",
			"🧗🏾‍♂️",
			"🧗🏾‍♂",
			"🧗🏿‍♂️",
			"🧗🏿‍♂",
			"🧗‍♀️",
			"🧗‍♀",
			"🧗🏻‍♀️",
			"🧗🏻‍♀",
			"🧗🏼‍♀️",
			"🧗🏼‍♀",
			"🧗🏽‍♀️",
			"🧗🏽‍♀",
			"🧗🏾‍♀️",
			"🧗🏾‍♀",
			"🧗🏿‍♀️",
			"🧗🏿‍♀",
			"🤺",
			"🏇",
			"🏇🏻",
			"🏇🏼",
			"🏇🏽",
			"🏇🏾",
			"🏇🏿",
			"⛷️",
			"⛷",
			"🏂",
			"🏂🏻",
			"🏂🏼",
			"🏂🏽",
			"🏂🏾",
			"🏂🏿",
			"🏌️",
			"🏌",
			"🏌🏻",
			"🏌🏼",
			"🏌🏽",
			"🏌🏾",
			"🏌🏿",
			"🏌️‍♂️",
			"🏌‍♂️",
			"🏌️‍♂",
			"🏌‍♂",
			"🏌🏻‍♂️",
			"🏌🏻‍♂",
			"🏌🏼‍♂️",
			"🏌🏼‍♂",
			"🏌🏽‍♂️",
			"🏌🏽‍♂",
			"🏌🏾‍♂️",
			"🏌🏾‍♂",
			"🏌🏿‍♂️",
			"🏌🏿‍♂",
			"🏌️‍♀️",
			"🏌‍♀️",
			"🏌️‍♀",
			"🏌‍♀",
			"🏌🏻‍♀️",
			"🏌🏻‍♀",
			"🏌🏼‍♀️",
			"🏌🏼‍♀",
			"🏌🏽‍♀️",
			"🏌🏽‍♀",
			"🏌🏾‍♀️",
			"🏌🏾‍♀",
			"🏌🏿‍♀️",
			"🏌🏿‍♀",
			"🏄",
			"🏄🏻",
			"🏄🏼",
			"🏄🏽",
			"🏄🏾",
			"🏄🏿",
			"🏄‍♂️",
			"🏄‍♂",
			"🏄🏻‍♂️",
			"🏄🏻‍♂",
			"🏄🏼‍♂️",
			"🏄🏼‍♂",
			"🏄🏽‍♂️",
			"🏄🏽‍♂",
			"🏄🏾‍♂️",
			"🏄🏾‍♂",
			"🏄🏿‍♂️",
			"🏄🏿‍♂",
			"🏄‍♀️",
			"🏄‍♀",
			"🏄🏻‍♀️",
			"🏄🏻‍♀",
			"🏄🏼‍♀️",
			"🏄🏼‍♀",
			"🏄🏽‍♀️",
			"🏄🏽‍♀",
			"🏄🏾‍♀️",
			"🏄🏾‍♀",
			"🏄🏿‍♀️",
			"🏄🏿‍♀",
			"🚣",
			"🚣🏻",
			"🚣🏼",
			"🚣🏽",
			"🚣🏾",
			"🚣🏿",
			"🚣‍♂️",
			"🚣‍♂",
			"🚣🏻‍♂️",
			"🚣🏻‍♂",
			"🚣🏼‍♂️",
			"🚣🏼‍♂",
			"🚣🏽‍♂️",
			"🚣🏽‍♂",
			"🚣🏾‍♂️",
			"🚣🏾‍♂",
			"🚣🏿‍♂️",
			"🚣🏿‍♂",
			"🚣‍♀️",
			"🚣‍♀",
			"🚣🏻‍♀️",
			"🚣🏻‍♀",
			"🚣🏼‍♀️",
			"🚣🏼‍♀",
			"🚣🏽‍♀️",
			"🚣🏽‍♀",
			"🚣🏾‍♀️",
			"🚣🏾‍♀",
			"🚣🏿‍♀️",
			"🚣🏿‍♀",
			"🏊",
			"🏊🏻",
			"🏊🏼",
			"🏊🏽",
			"🏊🏾",
			"🏊🏿",
			"🏊‍♂️",
			"🏊‍♂",
			"🏊🏻‍♂️",
			"🏊🏻‍♂",
			"🏊🏼‍♂️",
			"🏊🏼‍♂",
			"🏊🏽‍♂️",
			"🏊🏽‍♂",
			"🏊🏾‍♂️",
			"🏊🏾‍♂",
			"🏊🏿‍♂️",
			"🏊🏿‍♂",
			"🏊‍♀️",
			"🏊‍♀",
			"🏊🏻‍♀️",
			"🏊🏻‍♀",
			"🏊🏼‍♀️",
			"🏊🏼‍♀",
			"🏊🏽‍♀️",
			"🏊🏽‍♀",
			"🏊🏾‍♀️",
			"🏊🏾‍♀",
			"🏊🏿‍♀️",
			"🏊🏿‍♀",
			"⛹️",
			"⛹",
			"⛹🏻",
			"⛹🏼",
			"⛹🏽",
			"⛹🏾",
			"⛹🏿",
			"⛹️‍♂️",
			"⛹‍♂️",
			"⛹️‍♂",
			"⛹‍♂",
			"⛹🏻‍♂️",
			"⛹🏻‍♂",
			"⛹🏼‍♂️",
			"⛹🏼‍♂",
			"⛹🏽‍♂️",
			"⛹🏽‍♂",
			"⛹🏾‍♂️",
			"⛹🏾‍♂",
			"⛹🏿‍♂️",
			"⛹🏿‍♂",
			"⛹️‍♀️",
			"⛹‍♀️",
			"⛹️‍♀",
			"⛹‍♀",
			"⛹🏻‍♀️",
			"⛹🏻‍♀",
			"⛹🏼‍♀️",
			"⛹🏼‍♀",
			"⛹🏽‍♀️",
			"⛹🏽‍♀",
			"⛹🏾‍♀️",
			"⛹🏾‍♀",
			"⛹🏿‍♀️",
			"⛹🏿‍♀",
			"🏋️",
			"🏋",
			"🏋🏻",
			"🏋🏼",
			"🏋🏽",
			"🏋🏾",
			"🏋🏿",
			"🏋️‍♂️",
			"🏋‍♂️",
			"🏋️‍♂",
			"🏋‍♂",
			"🏋🏻‍♂️",
			"🏋🏻‍♂",
			"🏋🏼‍♂️",
			"🏋🏼‍♂",
			"🏋🏽‍♂️",
			"🏋🏽‍♂",
			"🏋🏾‍♂️",
			"🏋🏾‍♂",
			"🏋🏿‍♂️",
			"🏋🏿‍♂",
			"🏋️‍♀️",
			"🏋‍♀️",
			"🏋️‍♀",
			"🏋‍♀",
			"🏋🏻‍♀️",
			"🏋🏻‍♀",
			"🏋🏼‍♀️",
			"🏋🏼‍♀",
			"🏋🏽‍♀️",
			"🏋🏽‍♀",
			"🏋🏾‍♀️",
			"🏋🏾‍♀",
			"🏋🏿‍♀️",
			"🏋🏿‍♀",
			"🚴",
			"🚴🏻",
			"🚴🏼",
			"🚴🏽",
			"🚴🏾",
			"🚴🏿",
			"🚴‍♂️",
			"🚴‍♂",
			"🚴🏻‍♂️",
			"🚴🏻‍♂",
			"🚴🏼‍♂️",
			"🚴🏼‍♂",
			"🚴🏽‍♂️",
			"🚴🏽‍♂",
			"🚴🏾‍♂️",
			"🚴🏾‍♂",
			"🚴🏿‍♂️",
			"🚴🏿‍♂",
			"🚴‍♀️",
			"🚴‍♀",
			"🚴🏻‍♀️",
			"🚴🏻‍♀",
			"🚴🏼‍♀️",
			"🚴🏼‍♀",
			"🚴🏽‍♀️",
			"🚴🏽‍♀",
			"🚴🏾‍♀️",
			"🚴🏾‍♀",
			"🚴🏿‍♀️",
			"🚴🏿‍♀",
			"🚵",
			"🚵🏻",
			"🚵🏼",
			"🚵🏽",
			"🚵🏾",
			"🚵🏿",
			"🚵‍♂️",
			"🚵‍♂",
			"🚵🏻‍♂️",
			"🚵🏻‍♂",
			"🚵🏼‍♂️",
			"🚵🏼‍♂",
			"🚵🏽‍♂️",
			"🚵🏽‍♂",
			"🚵🏾‍♂️",
			"🚵🏾‍♂",
			"🚵🏿‍♂️",
			"🚵🏿‍♂",
			"🚵‍♀️",
			"🚵‍♀",
			"🚵🏻‍♀️",
			"🚵🏻‍♀",
			"🚵🏼‍♀️",
			"🚵🏼‍♀",
			"🚵🏽‍♀️",
			"🚵🏽‍♀",
			"🚵🏾‍♀️",
			"🚵🏾‍♀",
			"🚵🏿‍♀️",
			"🚵🏿‍♀",
			"🤸",
			"🤸🏻",
			"🤸🏼",
			"🤸🏽",
			"🤸🏾",
			"🤸🏿",
			"🤸‍♂️",
			"🤸‍♂",
			"🤸🏻‍♂️",
			"🤸🏻‍♂",
			"🤸🏼‍♂️",
			"🤸🏼‍♂",
			"🤸🏽‍♂️",
			"🤸🏽‍♂",
			"🤸🏾‍♂️",
			"🤸🏾‍♂",
			"🤸🏿‍♂️",
			"🤸🏿‍♂",
			"🤸‍♀️",
			"🤸‍♀",
			"🤸🏻‍♀️",
			"🤸🏻‍♀",
			"🤸🏼‍♀️",
			"🤸🏼‍♀",
			"🤸🏽‍♀️",
			"🤸🏽‍♀",
			"🤸🏾‍♀️",
			"🤸🏾‍♀",
			"🤸🏿‍♀️",
			"🤸🏿‍♀",
			"🤼",
			"🤼‍♂️",
			"🤼‍♂",
			"🤼‍♀️",
			"🤼‍♀",
			"🤽",
			"🤽🏻",
			"🤽🏼",
			"🤽🏽",
			"🤽🏾",
			"🤽🏿",
			"🤽‍♂️",
			"🤽‍♂",
			"🤽🏻‍♂️",
			"🤽🏻‍♂",
			"🤽🏼‍♂️",
			"🤽🏼‍♂",
			"🤽🏽‍♂️",
			"🤽🏽‍♂",
			"🤽🏾‍♂️",
			"🤽🏾‍♂",
			"🤽🏿‍♂️",
			"🤽🏿‍♂",
			"🤽‍♀️",
			"🤽‍♀",
			"🤽🏻‍♀️",
			"🤽🏻‍♀",
			"🤽🏼‍♀️",
			"🤽🏼‍♀",
			"🤽🏽‍♀️",
			"🤽🏽‍♀",
			"🤽🏾‍♀️",
			"🤽🏾‍♀",
			"🤽🏿‍♀️",
			"🤽🏿‍♀",
			"🤾",
			"🤾🏻",
			"🤾🏼",
			"🤾🏽",
			"🤾🏾",
			"🤾🏿",
			"🤾‍♂️",
			"🤾‍♂",
			"🤾🏻‍♂️",
			"🤾🏻‍♂",
			"🤾🏼‍♂️",
			"🤾🏼‍♂",
			"🤾🏽‍♂️",
			"🤾🏽‍♂",
			"🤾🏾‍♂️",
			"🤾🏾‍♂",
			"🤾🏿‍♂️",
			"🤾🏿‍♂",
			"🤾‍♀️",
			"🤾‍♀",
			"🤾🏻‍♀️",
			"🤾🏻‍♀",
			"🤾🏼‍♀️",
			"🤾🏼‍♀",
			"🤾🏽‍♀️",
			"🤾🏽‍♀",
			"🤾🏾‍♀️",
			"🤾🏾‍♀",
			"🤾🏿‍♀️",
			"🤾🏿‍♀",
			"🤹",
			"🤹🏻",
			"🤹🏼",
			"🤹🏽",
			"🤹🏾",
			"🤹🏿",
			"🤹‍♂️",
			"🤹‍♂",
			"🤹🏻‍♂️",
			"🤹🏻‍♂",
			"🤹🏼‍♂️",
			"🤹🏼‍♂",
			"🤹🏽‍♂️",
			"🤹🏽‍♂",
			"🤹🏾‍♂️",
			"🤹🏾‍♂",
			"🤹🏿‍♂️",
			"🤹🏿‍♂",
			"🤹‍♀️",
			"🤹‍♀",
			"🤹🏻‍♀️",
			"🤹🏻‍♀",
			"🤹🏼‍♀️",
			"🤹🏼‍♀",
			"🤹🏽‍♀️",
			"🤹🏽‍♀",
			"🤹🏾‍♀️",
			"🤹🏾‍♀",
			"🤹🏿‍♀️",
			"🤹🏿‍♀",
			"🧘",
			"🧘🏻",
			"🧘🏼",
			"🧘🏽",
			"🧘🏾",
			"🧘🏿",
			"🧘‍♂️",
			"🧘‍♂",
			"🧘🏻‍♂️",
			"🧘🏻‍♂",
			"🧘🏼‍♂️",
			"🧘🏼‍♂",
			"🧘🏽‍♂️",
			"🧘🏽‍♂",
			"🧘🏾‍♂️",
			"🧘🏾‍♂",
			"🧘🏿‍♂️",
			"🧘🏿‍♂",
			"🧘‍♀️",
			"🧘‍♀",
			"🧘🏻‍♀️",
			"🧘🏻‍♀",
			"🧘🏼‍♀️",
			"🧘🏼‍♀",
			"🧘🏽‍♀️",
			"🧘🏽‍♀",
			"🧘🏾‍♀️",
			"🧘🏾‍♀",
			"🧘🏿‍♀️",
			"🧘🏿‍♀",
			"🛀",
			"🛀🏻",
			"🛀🏼",
			"🛀🏽",
			"🛀🏾",
			"🛀🏿",
			"🛌",
			"🛌🏻",
			"🛌🏼",
			"🛌🏽",
			"🛌🏾",
			"🛌🏿",
			"🧑‍🤝‍🧑",
			"🧑🏻‍🤝‍🧑🏻",
			"🧑🏻‍🤝‍🧑🏼",
			"🧑🏻‍🤝‍🧑🏽",
			"🧑🏻‍🤝‍🧑🏾",
			"🧑🏻‍🤝‍🧑🏿",
			"🧑🏼‍🤝‍🧑🏻",
			"🧑🏼‍🤝‍🧑🏼",
			"🧑🏼‍🤝‍🧑🏽",
			"🧑🏼‍🤝‍🧑🏾",
			"🧑🏼‍🤝‍🧑🏿",
			"🧑🏽‍🤝‍🧑🏻",
			"🧑🏽‍🤝‍🧑🏼",
			"🧑🏽‍🤝‍🧑🏽",
			"🧑🏽‍🤝‍🧑🏾",
			"🧑🏽‍🤝‍🧑🏿",
			"🧑🏾‍🤝‍🧑🏻",
			"🧑🏾‍🤝‍🧑🏼",
			"🧑🏾‍🤝‍🧑🏽",
			"🧑🏾‍🤝‍🧑🏾",
			"🧑🏾‍🤝‍🧑🏿",
			"🧑🏿‍🤝‍🧑🏻",
			"🧑🏿‍🤝‍🧑🏼",
			"🧑🏿‍🤝‍🧑🏽",
			"🧑🏿‍🤝‍🧑🏾",
			"🧑🏿‍🤝‍🧑🏿",
			"👭",
			"👭🏻",
			"👩🏻‍🤝‍👩🏼",
			"👩🏻‍🤝‍👩🏽",
			"👩🏻‍🤝‍👩🏾",
			"👩🏻‍🤝‍👩🏿",
			"👩🏼‍🤝‍👩🏻",
			"👭🏼",
			"👩🏼‍🤝‍👩🏽",
			"👩🏼‍🤝‍👩🏾",
			"👩🏼‍🤝‍👩🏿",
			"👩🏽‍🤝‍👩🏻",
			"👩🏽‍🤝‍👩🏼",
			"👭🏽",
			"👩🏽‍🤝‍👩🏾",
			"👩🏽‍🤝‍👩🏿",
			"👩🏾‍🤝‍👩🏻",
			"👩🏾‍🤝‍👩🏼",
			"👩🏾‍🤝‍👩🏽",
			"👭🏾",
			"👩🏾‍🤝‍👩🏿",
			"👩🏿‍🤝‍👩🏻",
			"👩🏿‍🤝‍👩🏼",
			"👩🏿‍🤝‍👩🏽",
			"👩🏿‍🤝‍👩🏾",
			"👭🏿",
			"👫",
			"👫🏻",
			"👩🏻‍🤝‍👨🏼",
			"👩🏻‍🤝‍👨🏽",
			"👩🏻‍🤝‍👨🏾",
			"👩🏻‍🤝‍👨🏿",
			"👩🏼‍🤝‍👨🏻",
			"👫🏼",
			"👩🏼‍🤝‍👨🏽",
			"👩🏼‍🤝‍👨🏾",
			"👩🏼‍🤝‍👨🏿",
			"👩🏽‍🤝‍👨🏻",
			"👩🏽‍🤝‍👨🏼",
			"👫🏽",
			"👩🏽‍🤝‍👨🏾",
			"👩🏽‍🤝‍👨🏿",
			"👩🏾‍🤝‍👨🏻",
			"👩🏾‍🤝‍👨🏼",
			"👩🏾‍🤝‍👨🏽",
			"👫🏾",
			"👩🏾‍🤝‍👨🏿",
			"👩🏿‍🤝‍👨🏻",
			"👩🏿‍🤝‍👨🏼",
			"👩🏿‍🤝‍👨🏽",
			"👩🏿‍🤝‍👨🏾",
			"👫🏿",
			"👬",
			"👬🏻",
			"👨🏻‍🤝‍👨🏼",
			"👨🏻‍🤝‍👨🏽",
			"👨🏻‍🤝‍👨🏾",
			"👨🏻‍🤝‍👨🏿",
			"👨🏼‍🤝‍👨🏻",
			"👬🏼",
			"👨🏼‍🤝‍👨🏽",
			"👨🏼‍🤝‍👨🏾",
			"👨🏼‍🤝‍👨🏿",
			"👨🏽‍🤝‍👨🏻",
			"👨🏽‍🤝‍👨🏼",
			"👬🏽",
			"👨🏽‍🤝‍👨🏾",
			"👨🏽‍🤝‍👨🏿",
			"👨🏾‍🤝‍👨🏻",
			"👨🏾‍🤝‍👨🏼",
			"👨🏾‍🤝‍👨🏽",
			"👬🏾",
			"👨🏾‍🤝‍👨🏿",
			"👨🏿‍🤝‍👨🏻",
			"👨🏿‍🤝‍👨🏼",
			"👨🏿‍🤝‍👨🏽",
			"👨🏿‍🤝‍👨🏾",
			"👬🏿",
			"💏",
			"👩‍❤️‍💋‍👨",
			"👩‍❤‍💋‍👨",
			"👨‍❤️‍💋‍👨",
			"👨‍❤‍💋‍👨",
			"👩‍❤️‍💋‍👩",
			"👩‍❤‍💋‍👩",
			"💑",
			"👩‍❤️‍👨",
			"👩‍❤‍👨",
			"👨‍❤️‍👨",
			"👨‍❤‍👨",
			"👩‍❤️‍👩",
			"👩‍❤‍👩",
			"👪",
			"👨‍👩‍👦",
			"👨‍👩‍👧",
			"👨‍👩‍👧‍👦",
			"👨‍👩‍👦‍👦",
			"👨‍👩‍👧‍👧",
			"👨‍👨‍👦",
			"👨‍👨‍👧",
			"👨‍👨‍👧‍👦",
			"👨‍👨‍👦‍👦",
			"👨‍👨‍👧‍👧",
			"👩‍👩‍👦",
			"👩‍👩‍👧",
			"👩‍👩‍👧‍👦",
			"👩‍👩‍👦‍👦",
			"👩‍👩‍👧‍👧",
			"👨‍👦",
			"👨‍👦‍👦",
			"👨‍👧",
			"👨‍👧‍👦",
			"👨‍👧‍👧",
			"👩‍👦",
			"👩‍👦‍👦",
			"👩‍👧",
			"👩‍👧‍👦",
			"👩‍👧‍👧",
			"🗣️",
			"🗣",
			"👤",
			"👥",
			"🫂",
			"👣",
			"🏻",
			"🏼",
			"🏽",
			"🏾",
			"🏿",
			"🦰",
			"🦱",
			"🦳",
			"🦲",
			"🐵",
			"🐒",
			"🦍",
			"🦧",
			"🐶",
			"🐕",
			"🦮",
			"🐕‍🦺",
			"🐩",
			"🐺",
			"🦊",
			"🦝",
			"🐱",
			"🐈",
			"🐈‍⬛",
			"🦁",
			"🐯",
			"🐅",
			"🐆",
			"🐴",
			"🐎",
			"🦄",
			"🦓",
			"🦌",
			"🦬",
			"🐮",
			"🐂",
			"🐃",
			"🐄",
			"🐷",
			"🐖",
			"🐗",
			"🐽",
			"🐏",
			"🐑",
			"🐐",
			"🐪",
			"🐫",
			"🦙",
			"🦒",
			"🐘",
			"🦣",
			"🦏",
			"🦛",
			"🐭",
			"🐁",
			"🐀",
			"🐹",
			"🐰",
			"🐇",
			"🐿️",
			"🐿",
			"🦫",
			"🦔",
			"🦇",
			"🐻",
			"🐻‍❄️",
			"🐻‍❄",
			"🐨",
			"🐼",
			"🦥",
			"🦦",
			"🦨",
			"🦘",
			"🦡",
			"🐾",
			"🦃",
			"🐔",
			"🐓",
			"🐣",
			"🐤",
			"🐥",
			"🐦",
			"🐧",
			"🕊️",
			"🕊",
			"🦅",
			"🦆",
			"🦢",
			"🦉",
			"🦤",
			"🪶",
			"🦩",
			"🦚",
			"🦜",
			"🐸",
			"🐊",
			"🐢",
			"🦎",
			"🐍",
			"🐲",
			"🐉",
			"🦕",
			"🦖",
			"🐳",
			"🐋",
			"🐬",
			"🦭",
			"🐟",
			"🐠",
			"🐡",
			"🦈",
			"🐙",
			"🐚",
			"🐌",
			"🦋",
			"🐛",
			"🐜",
			"🐝",
			"🪲",
			"🐞",
			"🦗",
			"🪳",
			"🕷️",
			"🕷",
			"🕸️",
			"🕸",
			"🦂",
			"🦟",
			"🪰",
			"🪱",
			"🦠",
			"💐",
			"🌸",
			"💮",
			"🏵️",
			"🏵",
			"🌹",
			"🥀",
			"🌺",
			"🌻",
			"🌼",
			"🌷",
			"🌱",
			"🪴",
			"🌲",
			"🌳",
			"🌴",
			"🌵",
			"🌾",
			"🌿",
			"☘️",
			"☘",
			"🍀",
			"🍁",
			"🍂",
			"🍃",
			"🍇",
			"🍈",
			"🍉",
			"🍊",
			"🍋",
			"🍌",
			"🍍",
			"🥭",
			"🍎",
			"🍏",
			"🍐",
			"🍑",
			"🍒",
			"🍓",
			"🫐",
			"🥝",
			"🍅",
			"🫒",
			"🥥",
			"🥑",
			"🍆",
			"🥔",
			"🥕",
			"🌽",
			"🌶️",
			"🌶",
			"🫑",
			"🥒",
			"🥬",
			"🥦",
			"🧄",
			"🧅",
			"🍄",
			"🥜",
			"🌰",
			"🍞",
			"🥐",
			"🥖",
			"🫓",
			"🥨",
			"🥯",
			"🥞",
			"🧇",
			"🧀",
			"🍖",
			"🍗",
			"🥩",
			"🥓",
			"🍔",
			"🍟",
			"🍕",
			"🌭",
			"🥪",
			"🌮",
			"🌯",
			"🫔",
			"🥙",
			"🧆",
			"🥚",
			"🍳",
			"🥘",
			"🍲",
			"🫕",
			"🥣",
			"🥗",
			"🍿",
			"🧈",
			"🧂",
			"🥫",
			"🍱",
			"🍘",
			"🍙",
			"🍚",
			"🍛",
			"🍜",
			"🍝",
			"🍠",
			"🍢",
			"🍣",
			"🍤",
			"🍥",
			"🥮",
			"🍡",
			"🥟",
			"🥠",
			"🥡",
			"🦀",
			"🦞",
			"🦐",
			"🦑",
			"🦪",
			"🍦",
			"🍧",
			"🍨",
			"🍩",
			"🍪",
			"🎂",
			"🍰",
			"🧁",
			"🥧",
			"🍫",
			"🍬",
			"🍭",
			"🍮",
			"🍯",
			"🍼",
			"🥛",
			"☕",
			"🫖",
			"🍵",
			"🍶",
			"🍾",
			"🍷",
			"🍸",
			"🍹",
			"🍺",
			"🍻",
			"🥂",
			"🥃",
			"🥤",
			"🧋",
			"🧃",
			"🧉",
			"🧊",
			"🥢",
			"🍽️",
			"🍽",
			"🍴",
			"🥄",
			"🔪",
			"🏺",
			"🌍",
			"🌎",
			"🌏",
			"🌐",
			"🗺️",
			"🗺",
			"🗾",
			"🧭",
			"🏔️",
			"🏔",
			"⛰️",
			"⛰",
			"🌋",
			"🗻",
			"🏕️",
			"🏕",
			"🏖️",
			"🏖",
			"🏜️",
			"🏜",
			"🏝️",
			"🏝",
			"🏞️",
			"🏞",
			"🏟️",
			"🏟",
			"🏛️",
			"🏛",
			"🏗️",
			"🏗",
			"🧱",
			"🪨",
			"🪵",
			"🛖",
			"🏘️",
			"🏘",
			"🏚️",
			"🏚",
			"🏠",
			"🏡",
			"🏢",
			"🏣",
			"🏤",
			"🏥",
			"🏦",
			"🏨",
			"🏩",
			"🏪",
			"🏫",
			"🏬",
			"🏭",
			"🏯",
			"🏰",
			"💒",
			"🗼",
			"🗽",
			"⛪",
			"🕌",
			"🛕",
			"🕍",
			"⛩️",
			"⛩",
			"🕋",
			"⛲",
			"⛺",
			"🌁",
			"🌃",
			"🏙️",
			"🏙",
			"🌄",
			"🌅",
			"🌆",
			"🌇",
			"🌉",
			"♨️",
			"♨",
			"🎠",
			"🎡",
			"🎢",
			"💈",
			"🎪",
			"🚂",
			"🚃",
			"🚄",
			"🚅",
			"🚆",
			"🚇",
			"🚈",
			"🚉",
			"🚊",
			"🚝",
			"🚞",
			"🚋",
			"🚌",
			"🚍",
			"🚎",
			"🚐",
			"🚑",
			"🚒",
			"🚓",
			"🚔",
			"🚕",
			"🚖",
			"🚗",
			"🚘",
			"🚙",
			"🛻",
			"🚚",
			"🚛",
			"🚜",
			"🏎️",
			"🏎",
			"🏍️",
			"🏍",
			"🛵",
			"🦽",
			"🦼",
			"🛺",
			"🚲",
			"🛴",
			"🛹",
			"🛼",
			"🚏",
			"🛣️",
			"🛣",
			"🛤️",
			"🛤",
			"🛢️",
			"🛢",
			"⛽",
			"🚨",
			"🚥",
			"🚦",
			"🛑",
			"🚧",
			"⚓",
			"⛵",
			"🛶",
			"🚤",
			"🛳️",
			"🛳",
			"⛴️",
			"⛴",
			"🛥️",
			"🛥",
			"🚢",
			"✈️",
			"✈",
			"🛩️",
			"🛩",
			"🛫",
			"🛬",
			"🪂",
			"💺",
			"🚁",
			"🚟",
			"🚠",
			"🚡",
			"🛰️",
			"🛰",
			"🚀",
			"🛸",
			"🛎️",
			"🛎",
			"🧳",
			"⌛",
			"⏳",
			"⌚",
			"⏰",
			"⏱️",
			"⏱",
			"⏲️",
			"⏲",
			"🕰️",
			"🕰",
			"🕛",
			"🕧",
			"🕐",
			"🕜",
			"🕑",
			"🕝",
			"🕒",
			"🕞",
			"🕓",
			"🕟",
			"🕔",
			"🕠",
			"🕕",
			"🕡",
			"🕖",
			"🕢",
			"🕗",
			"🕣",
			"🕘",
			"🕤",
			"🕙",
			"🕥",
			"🕚",
			"🕦",
			"🌑",
			"🌒",
			"🌓",
			"🌔",
			"🌕",
			"🌖",
			"🌗",
			"🌘",
			"🌙",
			"🌚",
			"🌛",
			"🌜",
			"🌡️",
			"🌡",
			"☀️",
			"☀",
			"🌝",
			"🌞",
			"🪐",
			"⭐",
			"🌟",
			"🌠",
			"🌌",
			"☁️",
			"☁",
			"⛅",
			"⛈️",
			"⛈",
			"🌤️",
			"🌤",
			"🌥️",
			"🌥",
			"🌦️",
			"🌦",
			"🌧️",
			"🌧",
			"🌨️",
			"🌨",
			"🌩️",
			"🌩",
			"🌪️",
			"🌪",
			"🌫️",
			"🌫",
			"🌬️",
			"🌬",
			"🌀",
			"🌈",
			"🌂",
			"☂️",
			"☂",
			"☔",
			"⛱️",
			"⛱",
			"⚡",
			"❄️",
			"❄",
			"☃️",
			"☃",
			"⛄",
			"☄️",
			"☄",
			"🔥",
			"💧",
			"🌊",
			"🎃",
			"🎄",
			"🎆",
			"🎇",
			"🧨",
			"✨",
			"🎈",
			"🎉",
			"🎊",
			"🎋",
			"🎍",
			"🎎",
			"🎏",
			"🎐",
			"🎑",
			"🧧",
			"🎀",
			"🎁",
			"🎗️",
			"🎗",
			"🎟️",
			"🎟",
			"🎫",
			"🎖️",
			"🎖",
			"🏆",
			"🏅",
			"🥇",
			"🥈",
			"🥉",
			"⚽",
			"⚾",
			"🥎",
			"🏀",
			"🏐",
			"🏈",
			"🏉",
			"🎾",
			"🥏",
			"🎳",
			"🏏",
			"🏑",
			"🏒",
			"🥍",
			"🏓",
			"🏸",
			"🥊",
			"🥋",
			"🥅",
			"⛳",
			"⛸️",
			"⛸",
			"🎣",
			"🤿",
			"🎽",
			"🎿",
			"🛷",
			"🥌",
			"🎯",
			"🪀",
			"🪁",
			"🎱",
			"🔮",
			"🪄",
			"🧿",
			"🎮",
			"🕹️",
			"🕹",
			"🎰",
			"🎲",
			"🧩",
			"🧸",
			"🪅",
			"🪆",
			"♠️",
			"♠",
			"♥️",
			"♥",
			"♦️",
			"♦",
			"♣️",
			"♣",
			"♟️",
			"♟",
			"🃏",
			"🀄",
			"🎴",
			"🎭",
			"🖼️",
			"🖼",
			"🎨",
			"🧵",
			"🪡",
			"🧶",
			"🪢",
			"👓",
			"🕶️",
			"🕶",
			"🥽",
			"🥼",
			"🦺",
			"👔",
			"👕",
			"👖",
			"🧣",
			"🧤",
			"🧥",
			"🧦",
			"👗",
			"👘",
			"🥻",
			"🩱",
			"🩲",
			"🩳",
			"👙",
			"👚",
			"👛",
			"👜",
			"👝",
			"🛍️",
			"🛍",
			"🎒",
			"🩴",
			"👞",
			"👟",
			"🥾",
			"🥿",
			"👠",
			"👡",
			"🩰",
			"👢",
			"👑",
			"👒",
			"🎩",
			"🎓",
			"🧢",
			"🪖",
			"⛑️",
			"⛑",
			"📿",
			"💄",
			"💍",
			"💎",
			"🔇",
			"🔈",
			"🔉",
			"🔊",
			"📢",
			"📣",
			"📯",
			"🔔",
			"🔕",
			"🎼",
			"🎵",
			"🎶",
			"🎙️",
			"🎙",
			"🎚️",
			"🎚",
			"🎛️",
			"🎛",
			"🎤",
			"🎧",
			"📻",
			"🎷",
			"🪗",
			"🎸",
			"🎹",
			"🎺",
			"🎻",
			"🪕",
			"🥁",
			"🪘",
			"📱",
			"📲",
			"☎️",
			"☎",
			"📞",
			"📟",
			"📠",
			"🔋",
			"🔌",
			"💻",
			"🖥️",
			"🖥",
			"🖨️",
			"🖨",
			"⌨️",
			"⌨",
			"🖱️",
			"🖱",
			"🖲️",
			"🖲",
			"💽",
			"💾",
			"💿",
			"📀",
			"🧮",
			"🎥",
			"🎞️",
			"🎞",
			"📽️",
			"📽",
			"🎬",
			"📺",
			"📷",
			"📸",
			"📹",
			"📼",
			"🔍",
			"🔎",
			"🕯️",
			"🕯",
			"💡",
			"🔦",
			"🏮",
			"🪔",
			"📔",
			"📕",
			"📖",
			"📗",
			"📘",
			"📙",
			"📚",
			"📓",
			"📒",
			"📃",
			"📜",
			"📄",
			"📰",
			"🗞️",
			"🗞",
			"📑",
			"🔖",
			"🏷️",
			"🏷",
			"💰",
			"🪙",
			"💴",
			"💵",
			"💶",
			"💷",
			"💸",
			"💳",
			"🧾",
			"💹",
			"✉️",
			"✉",
			"📧",
			"📨",
			"📩",
			"📤",
			"📥",
			"📦",
			"📫",
			"📪",
			"📬",
			"📭",
			"📮",
			"🗳️",
			"🗳",
			"✏️",
			"✏",
			"✒️",
			"✒",
			"🖋️",
			"🖋",
			"🖊️",
			"🖊",
			"🖌️",
			"🖌",
			"🖍️",
			"🖍",
			"📝",
			"💼",
			"📁",
			"📂",
			"🗂️",
			"🗂",
			"📅",
			"📆",
			"🗒️",
			"🗒",
			"🗓️",
			"🗓",
			"📇",
			"📈",
			"📉",
			"📊",
			"📋",
			"📌",
			"📍",
			"📎",
			"🖇️",
			"🖇",
			"📏",
			"📐",
			"✂️",
			"✂",
			"🗃️",
			"🗃",
			"🗄️",
			"🗄",
			"🗑️",
			"🗑",
			"🔒",
			"🔓",
			"🔏",
			"🔐",
			"🔑",
			"🗝️",
			"🗝",
			"🔨",
			"🪓",
			"⛏️",
			"⛏",
			"⚒️",
			"⚒",
			"🛠️",
			"🛠",
			"🗡️",
			"🗡",
			"⚔️",
			"⚔",
			"🔫",
			"🪃",
			"🏹",
			"🛡️",
			"🛡",
			"🪚",
			"🔧",
			"🪛",
			"🔩",
			"⚙️",
			"⚙",
			"🗜️",
			"🗜",
			"⚖️",
			"⚖",
			"🦯",
			"🔗",
			"⛓️",
			"⛓",
			"🪝",
			"🧰",
			"🧲",
			"🪜",
			"⚗️",
			"⚗",
			"🧪",
			"🧫",
			"🧬",
			"🔬",
			"🔭",
			"📡",
			"💉",
			"🩸",
			"💊",
			"🩹",
			"🩺",
			"🚪",
			"🛗",
			"🪞",
			"🪟",
			"🛏️",
			"🛏",
			"🛋️",
			"🛋",
			"🪑",
			"🚽",
			"🪠",
			"🚿",
			"🛁",
			"🪤",
			"🪒",
			"🧴",
			"🧷",
			"🧹",
			"🧺",
			"🧻",
			"🪣",
			"🧼",
			"🪥",
			"🧽",
			"🧯",
			"🛒",
			"🚬",
			"⚰️",
			"⚰",
			"🪦",
			"⚱️",
			"⚱",
			"🗿",
			"🪧",
			"🏧",
			"🚮",
			"🚰",
			"♿",
			"🚹",
			"🚺",
			"🚻",
			"🚼",
			"🚾",
			"🛂",
			"🛃",
			"🛄",
			"🛅",
			"⚠️",
			"⚠",
			"🚸",
			"⛔",
			"🚫",
			"🚳",
			"🚭",
			"🚯",
			"🚱",
			"🚷",
			"📵",
			"🔞",
			"☢️",
			"☢",
			"☣️",
			"☣",
			"⬆️",
			"⬆",
			"↗️",
			"↗",
			"➡️",
			"➡",
			"↘️",
			"↘",
			"⬇️",
			"⬇",
			"↙️",
			"↙",
			"⬅️",
			"⬅",
			"↖️",
			"↖",
			"↕️",
			"↕",
			"↔️",
			"↔",
			"↩️",
			"↩",
			"↪️",
			"↪",
			"⤴️",
			"⤴",
			"⤵️",
			"⤵",
			"🔃",
			"🔄",
			"🔙",
			"🔚",
			"🔛",
			"🔜",
			"🔝",
			"🛐",
			"⚛️",
			"⚛",
			"🕉️",
			"🕉",
			"✡️",
			"✡",
			"☸️",
			"☸",
			"☯️",
			"☯",
			"✝️",
			"✝",
			"☦️",
			"☦",
			"☪️",
			"☪",
			"☮️",
			"☮",
			"🕎",
			"🔯",
			"♈",
			"♉",
			"♊",
			"♋",
			"♌",
			"♍",
			"♎",
			"♏",
			"♐",
			"♑",
			"♒",
			"♓",
			"⛎",
			"🔀",
			"🔁",
			"🔂",
			"▶️",
			"▶",
			"⏩",
			"⏭️",
			"⏭",
			"⏯️",
			"⏯",
			"◀️",
			"◀",
			"⏪",
			"⏮️",
			"⏮",
			"🔼",
			"⏫",
			"🔽",
			"⏬",
			"⏸️",
			"⏸",
			"⏹️",
			"⏹",
			"⏺️",
			"⏺",
			"⏏️",
			"⏏",
			"🎦",
			"🔅",
			"🔆",
			"📶",
			"📳",
			"📴",
			"♀️",
			"♀",
			"♂️",
			"♂",
			"⚧️",
			"⚧",
			"✖️",
			"✖",
			"➕",
			"➖",
			"➗",
			"♾️",
			"♾",
			"‼️",
			"‼",
			"⁉️",
			"⁉",
			"❓",
			"❔",
			"❕",
			"❗",
			"〰️",
			"〰",
			"💱",
			"💲",
			"⚕️",
			"⚕",
			"♻️",
			"♻",
			"⚜️",
			"⚜",
			"🔱",
			"📛",
			"🔰",
			"⭕",
			"✅",
			"☑️",
			"☑",
			"✔️",
			"✔",
			"❌",
			"❎",
			"➰",
			"➿",
			"〽️",
			"〽",
			"✳️",
			"✳",
			"✴️",
			"✴",
			"❇️",
			"❇",
			"©️",
			"©",
			"®️",
			"®",
			"™️",
			"™",
			"#️⃣",
			"#⃣",
			"*️⃣",
			"*⃣",
			"0️⃣",
			"0⃣",
			"1️⃣",
			"1⃣",
			"2️⃣",
			"2⃣",
			"3️⃣",
			"3⃣",
			"4️⃣",
			"4⃣",
			"5️⃣",
			"5⃣",
			"6️⃣",
			"6⃣",
			"7️⃣",
			"7⃣",
			"8️⃣",
			"8⃣",
			"9️⃣",
			"9⃣",
			"🔟",
			"🔠",
			"🔡",
			"🔢",
			"🔣",
			"🔤",
			"🅰️",
			"🅰",
			"🆎",
			"🅱️",
			"🅱",
			"🆑",
			"🆒",
			"🆓",
			"ℹ️",
			"ℹ",
			"🆔",
			"Ⓜ️",
			"Ⓜ",
			"🆕",
			"🆖",
			"🅾️",
			"🅾",
			"🆗",
			"🅿️",
			"🅿",
			"🆘",
			"🆙",
			"🆚",
			"🈁",
			"🈂️",
			"🈂",
			"🈷️",
			"🈷",
			"🈶",
			"🈯",
			"🉐",
			"🈹",
			"🈚",
			"🈲",
			"🉑",
			"🈸",
			"🈴",
			"🈳",
			"㊗️",
			"㊗",
			"㊙️",
			"㊙",
			"🈺",
			"🈵",
			"🔴",
			"🟠",
			"🟡",
			"🟢",
			"🔵",
			"🟣",
			"🟤",
			"⚫",
			"⚪",
			"🟥",
			"🟧",
			"🟨",
			"🟩",
			"🟦",
			"🟪",
			"🟫",
			"⬛",
			"⬜",
			"◼️",
			"◼",
			"◻️",
			"◻",
			"◾",
			"◽",
			"▪️",
			"▪",
			"▫️",
			"▫",
			"🔶",
			"🔷",
			"🔸",
			"🔹",
			"🔺",
			"🔻",
			"💠",
			"🔘",
			"🔳",
			"🔲",
			"🏁",
			"🚩",
			"🎌",
			"🏴",
			"🏳️",
			"🏳",
			"🏳️‍🌈",
			"🏳‍🌈",
			"🏳️‍⚧️",
			"🏳‍⚧️",
			"🏳️‍⚧",
			"🏳‍⚧",
			"🏴‍☠️",
			"🏴‍☠",
			"🇦🇨",
			"🇦🇩",
			"🇦🇪",
			"🇦🇫",
			"🇦🇬",
			"🇦🇮",
			"🇦🇱",
			"🇦🇲",
			"🇦🇴",
			"🇦🇶",
			"🇦🇷",
			"🇦🇸",
			"🇦🇹",
			"🇦🇺",
			"🇦🇼",
			"🇦🇽",
			"🇦🇿",
			"🇧🇦",
			"🇧🇧",
			"🇧🇩",
			"🇧🇪",
			"🇧🇫",
			"🇧🇬",
			"🇧🇭",
			"🇧🇮",
			"🇧🇯",
			"🇧🇱",
			"🇧🇲",
			"🇧🇳",
			"🇧🇴",
			"🇧🇶",
			"🇧🇷",
			"🇧🇸",
			"🇧🇹",
			"🇧🇻",
			"🇧🇼",
			"🇧🇾",
			"🇧🇿",
			"🇨🇦",
			"🇨🇨",
			"🇨🇩",
			"🇨🇫",
			"🇨🇬",
			"🇨🇭",
			"🇨🇮",
			"🇨🇰",
			"🇨🇱",
			"🇨🇲",
			"🇨🇳",
			"🇨🇴",
			"🇨🇵",
			"🇨🇷",
			"🇨🇺",
			"🇨🇻",
			"🇨🇼",
			"🇨🇽",
			"🇨🇾",
			"🇨🇿",
			"🇩🇪",
			"🇩🇬",
			"🇩🇯",
			"🇩🇰",
			"🇩🇲",
			"🇩🇴",
			"🇩🇿",
			"🇪🇦",
			"🇪🇨",
			"🇪🇪",
			"🇪🇬",
			"🇪🇭",
			"🇪🇷",
			"🇪🇸",
			"🇪🇹",
			"🇪🇺",
			"🇫🇮",
			"🇫🇯",
			"🇫🇰",
			"🇫🇲",
			"🇫🇴",
			"🇫🇷",
			"🇬🇦",
			"🇬🇧",
			"🇬🇩",
			"🇬🇪",
			"🇬🇫",
			"🇬🇬",
			"🇬🇭",
			"🇬🇮",
			"🇬🇱",
			"🇬🇲",
			"🇬🇳",
			"🇬🇵",
			"🇬🇶",
			"🇬🇷",
			"🇬🇸",
			"🇬🇹",
			"🇬🇺",
			"🇬🇼",
			"🇬🇾",
			"🇭🇰",
			"🇭🇲",
			"🇭🇳",
			"🇭🇷",
			"🇭🇹",
			"🇭🇺",
			"🇮🇨",
			"🇮🇩",
			"🇮🇪",
			"🇮🇱",
			"🇮🇲",
			"🇮🇳",
			"🇮🇴",
			"🇮🇶",
			"🇮🇷",
			"🇮🇸",
			"🇮🇹",
			"🇯🇪",
			"🇯🇲",
			"🇯🇴",
			"🇯🇵",
			"🇰🇪",
			"🇰🇬",
			"🇰🇭",
			"🇰🇮",
			"🇰🇲",
			"🇰🇳",
			"🇰🇵",
			"🇰🇷",
			"🇰🇼",
			"🇰🇾",
			"🇰🇿",
			"🇱🇦",
			"🇱🇧",
			"🇱🇨",
			"🇱🇮",
			"🇱🇰",
			"🇱🇷",
			"🇱🇸",
			"🇱🇹",
			"🇱🇺",
			"🇱🇻",
			"🇱🇾",
			"🇲🇦",
			"🇲🇨",
			"🇲🇩",
			"🇲🇪",
			"🇲🇫",
			"🇲🇬",
			"🇲🇭",
			"🇲🇰",
			"🇲🇱",
			"🇲🇲",
			"🇲🇳",
			"🇲🇴",
			"🇲🇵",
			"🇲🇶",
			"🇲🇷",
			"🇲🇸",
			"🇲🇹",
			"🇲🇺",
			"🇲🇻",
			"🇲🇼",
			"🇲🇽",
			"🇲🇾",
			"🇲🇿",
			"🇳🇦",
			"🇳🇨",
			"🇳🇪",
			"🇳🇫",
			"🇳🇬",
			"🇳🇮",
			"🇳🇱",
			"🇳🇴",
			"🇳🇵",
			"🇳🇷",
			"🇳🇺",
			"🇳🇿",
			"🇴🇲",
			"🇵🇦",
			"🇵🇪",
			"🇵🇫",
			"🇵🇬",
			"🇵🇭",
			"🇵🇰",
			"🇵🇱",
			"🇵🇲",
			"🇵🇳",
			"🇵🇷",
			"🇵🇸",
			"🇵🇹",
			"🇵🇼",
			"🇵🇾",
			"🇶🇦",
			"🇷🇪",
			"🇷🇴",
			"🇷🇸",
			"🇷🇺",
			"🇷🇼",
			"🇸🇦",
			"🇸🇧",
			"🇸🇨",
			"🇸🇩",
			"🇸🇪",
			"🇸🇬",
			"🇸🇭",
			"🇸🇮",
			"🇸🇯",
			"🇸🇰",
			"🇸🇱",
			"🇸🇲",
			"🇸🇳",
			"🇸🇴",
			"🇸🇷",
			"🇸🇸",
			"🇸🇹",
			"🇸🇻",
			"🇸🇽",
			"🇸🇾",
			"🇸🇿",
			"🇹🇦",
			"🇹🇨",
			"🇹🇩",
			"🇹🇫",
			"🇹🇬",
			"🇹🇭",
			"🇹🇯",
			"🇹🇰",
			"🇹🇱",
			"🇹🇲",
			"🇹🇳",
			"🇹🇴",
			"🇹🇷",
			"🇹🇹",
			"🇹🇻",
			"🇹🇼",
			"🇹🇿",
			"🇺🇦",
			"🇺🇬",
			"🇺🇲",
			"🇺🇳",
			"🇺🇸",
			"🇺🇾",
			"🇺🇿",
			"🇻🇦",
			"🇻🇨",
			"🇻🇪",
			"🇻🇬",
			"🇻🇮",
			"🇻🇳",
			"🇻🇺",
			"🇼🇫",
			"🇼🇸",
			"🇽🇰",
			"🇾🇪",
			"🇾🇹",
			"🇿🇦",
			"🇿🇲",
			"🇿🇼",
			"🏴󠁧󠁢󠁥󠁮󠁧󠁿",
			"🏴󠁧󠁢󠁳󠁣󠁴󠁿",
			"🏴󠁧󠁢󠁷󠁬󠁳󠁿",
			"text with emoji 😜"
		];
		for (const emoji of emojis) {
			expect(string.hasEmoji(emoji)).toBe(true);
		}
	});

	it("should not identify non-emojis", () => {
		const others = ["Couple", "0", 0, null, false];

		for (const other of others) {
			expect(string.hasEmoji(other)).toBe(false);
		}
	});
});
