<?php

return function($site, $pages, $page) {

  $json = [];

  $products = $site->page('shop')->children()->listed()->sortBy('date', 'desc')->limit(16);

  foreach ($products as $product) {
    $json['data'][$product->id()] = [
      'page' => $product->toArray(),
      'authors' => $product->authors()->toPages()->pluck('title', true),
      'pretty_price' => (string)$product->prettyPrice(),
      'cover' => $product->getCover('shopCoverImage'),
      'category' => [
        'button' => $product->categories()->toPage()->button(),
        'title' => (string)$product->categories()->toPage()->title()
      ],
    ];
  }

  $products = json_encode($json);

  return compact(
    'products'
  );
};
