<?php

return function($site, $pages, $page) {

  $authors = $page->authors()->toPages();

  $similar = $similarPages = $page->similar([
    'index' => $page->siblings(false)->listed(),
    'fields' => [
      'tags' => 1,
      'authors' => 1.5,
      'category' => 3
    ],
    'threshold'      => 0.2,
    'delimiter'      => ',',
    'languageFilter' => false
  ]);

  if ($similar->count() < 4) {
    $fillups = $page->siblings(false)->listed();
    $fillups->shuffle();
    $similar = $similar->merge($fillups);
  }

  $similar = $similar->limit(4);

  if ($page->addPageToCart()) {
    /* If return true, product has been added to cart */
    /* This section only works with noJS and a sucessfull post form */

  }

  return compact(
    'authors',
    'similar'
  );
};
