<?php

return function($site, $pages, $page) {
  $limit = $page->paginationLimit()->toInt();
  $products = $page->children()->listed()->sortBy('date', 'desc');
  $products = $products->paginate($limit);
  $pagination = $products->pagination();

  $categories = [];
  foreach (kirby()->collection('categories') as $category) {
    $categories[$category->id()] = [
      'title' => $category->title(),
      'button' => $category->button(),
      'param' => $category->toParams($page->url()),
      'slug' => $category->slug()
    ];
  }

  return compact(
    'products',
    'pagination',
    'categories'
  );
};
