<?php

class CategoryPage extends Page {

  public function getElements() {
    $index = $this->site()->index();
    return $index->filterBy('categories', $this);
  }

  public function color() {
    if ($this->palette()->isNotEmpty()) {
      $palette =  $this->palette()->yaml();
      return $palette['background'];
    }
  }

  public function button() {
    if ($this->palette()->isNotEmpty()) {
      $palette =  $this->palette()->yaml();
      return $palette['button'];
    }
  }

  public function toParams($url) {
    return url($url, ['params' => ['category' => $this->slug()]]);
  }
}
