<?php
namespace Wizhou\Magasin;

/* Array
(
    [decimal_point] => ,
    [thousands_sep] =>
    [int_curr_symbol] => EUR
    [currency_symbol] => Eu
    [mon_decimal_point] => ,
    [mon_thousands_sep] =>
    [positive_sign] =>
    [negative_sign] => -
    [int_frac_digits] => 2
    [frac_digits] => 2
    [p_cs_precedes] => 0
    [p_sep_by_space] => 1
    [n_cs_precedes] => 0
    [n_sep_by_space] => 1
    [p_sign_posn] => 1
    [n_sign_posn] => 2
    [grouping] => Array
        (
            [0] => 127
        )

    [mon_grouping] => Array
        (
            [0] => 3
            [1] => 3
        )
) */


class Currency
{
  private $ISO;
  private $locale_info;
  private $currencyDetails;

  public function __construct($currency)
  {
    $this->locale_info = localeconv();
    $this->ISO = $currency;
    $this->currencyDetails = $this->getCurrencyDetails($this->ISO);
  }

  public function setCurrencySymbolInBlueprints () {
    $shop = kirby()->site()->page('shop');
    $shop->update([
      'currency_symbol' => $this->currencyDetails['symbol']
    ]);
  }

  public function ISO () {
    return $this->ISO;
  }

  public function localeInfo () {
    return $this->locale_info;
  }

  public function currencyDetails () {
    return $this->currencyDetails;
  }

  private function setToFloat($price)
  {
    if ($price  && !is_float($price)) {
      if ($price->isEmpty()) {
        throw new \Exception("The price field is empty", 1);
      }
      $price = $price->toFloat();
    };
    return $price;
  }

  public function toAmount($price)
  {
    $price = $this->setToFloat($price);
    $numberToBasic = $this->currencyDetails['numberToBasic'];
    return round($price * $numberToBasic);
  }

  public function toPrice($amount)
  {
    $numberToBasic = $this->currencyDetails['numberToBasic'];
    return (float) $amount / $numberToBasic;
  }

  public function format($price)
  {
    $price = $this->setToFloat($price);
    $decimals = $this->locale_info['frac_digits'];
    $decimalpoint = $this->locale_info['decimal_point'];
    $separator = $this->locale_info['thousands_sep'];
    return number_format($price, $decimals, $decimalpoint, $separator);
  }

  public function prettify($price, $type = 'price')
  {
    if ($type == 'price') {
      $formatedPrice = $this->format($price);
    } else if ($type == 'amount') {
      $formatedPrice = $this->toPrice($price);
      $formatedPrice = $this->format($formatedPrice);
    } else {
      throw new \Exception("The type must be of price or amount", 1);
    }
    
    $currencySymbol = $this->currencyDetails['symbol'];
    $prettyPrice = [];

    if ($this->locale_info['p_cs_precedes'] == 0) {
      /* The currency symbol follows the monetary quantity. */
      $prettyPrice = [$formatedPrice, $currencySymbol];
    } elseif ($this->locale_info['p_cs_precedes'] == 1) {
        /* The currency symbol precedes the monetary quantity. */
        $prettyPrice = [$currencySymbol, $formatedPrice];
    }

    if ($this->locale_info['p_sep_by_space'] == 0) {
      $prettyPrice = join('', $prettyPrice);
    } elseif ($this->locale_info['p_sep_by_space'] == 1) {
      $prettyPrice = join(' ', $prettyPrice);
    } else {
      $prettyPrice = join($prettyPrice);
    }

    return $prettyPrice;
  }

  static function getPriceBeforeTax ($priceIncludingTax, $tax)
  {
    return $priceIncludingTax / (1 + ($tax / 100));
  }

  static function getPriceIncludingTax ($priceBeforeTax, $tax)
  {
    return $priceBeforeTax * (1 + ($tax / 100));
  }

  static function getTaxAmout ($priceBeforeTax, $tax)
  {
    return $priceBeforeTax * ($tax / 100);
  }

  private function getCurrencyDetails ($ISO)
  {
    $symbol = null;
    switch ($ISO) {
      case 'ALL':
        $symbol = 'L';
        $numberToBasic = 100;
        $fullName = 'Albanian lek';
        break;

      case 'AMD':
        $symbol = '֏';
        $numberToBasic = 100;
        $fullName = 'Armenian dram';
        break;

      case 'BAM':
        $symbol = 'KM';
        $numberToBasic = 100;
        $fullName = 'Bosnia and Herzegovina convertible mark';
        break;

      case 'BGN':
        $symbol = 'лв';
        $numberToBasic = 100;
        $fullName = 'Bulgarian lev';
        break;

      case 'BYN':
        $symbol = 'Br';
        $numberToBasic = 100;
        $fullName = 'Belarusian ruble';
        break;

      case 'CHF':
        $symbol = 'Fr.';
        $numberToBasic = 100;
        $fullName = 'Swiss franc';
        break;

      case 'CZK':
        $symbol = 'Kč';
        $numberToBasic = 100;
        $fullName = 'Czech koruna';
        break;

      case 'DKK':
        $symbol = 'kr.';
        $numberToBasic = 100;
        $fullName = 'Danish krone';
        break;

      case 'EUR':
        $symbol = '€';
        $numberToBasic = 100;
        $fullName = 'Euro';
        break;

      case 'GBP':
        $symbol = '£';
        $numberToBasic = 100;
        $fullName = 'Sterling';
        break;

      case 'GEL':
        $symbol = '₾';
        $numberToBasic = 100;
        $fullName = 'Georgian lari';
        break;

      case 'HRK':
        $symbol = 'kn';
        $numberToBasic = 100;
        $fullName = 'Croatian kuna';
        break;

      case 'ISK':
        $symbol = 'Íkr';
        $numberToBasic = 100;
        $fullName = 'Icelandic króna';
        break;

      case 'MDL':
        $symbol = 'L';
        $numberToBasic = 100;
        $fullName = 'Moldovan leu';
        break;

      case 'NOK':
        $symbol = 'kr';
        $numberToBasic = 100;
        $fullName = 'Norwegian krone';
        break;

      case 'PLN':
        $symbol = 'zł';
        $numberToBasic = 100;
        $fullName = 'Polish złoty';
        break;

      case 'RON':
        $symbol = 'lei';
        $numberToBasic = 100;
        $fullName = 'Romanian leu';
        break;

      case 'RSD':
        $symbol = 'RSD';
        $numberToBasic = 100;
        $fullName = 'Serbian dinar';
        break;

      case 'RUB':
        $symbol = '₽';
        $numberToBasic = 100;
        $fullName = 'Russian ruble';
        break;

      case 'SEK':
        $symbol = 'kr';
        $numberToBasic = 100;
        $fullName = 'Swedish krona';
        break;

      case 'TRY':
        $symbol = '₺';
        $numberToBasic = 100;
        $fullName = 'Turkish lira';
        break;

      case 'UAH':
        $symbol = '₴';
        $numberToBasic = 100;
        $fullName = 'Ukrainian hryvnia';
        break;

      case 'USD':
        $symbol = '$';
        $numberToBasic = 100;
        $fullName = 'United States dollar';
        break;
    }

    return [
      'symbol' => $symbol,
      'numberToBasic' => $numberToBasic,
      'fullName' => $fullName
    ];
  }
}
