<?php
namespace Wizhou\Magasin;
use Wizhou\Magasin\Currency;
use Wizhou\Magasin\Shipping;
use Wizhou\Magasin\Payments;
use Kirby\Exception\Exception;

class Magasin
{
  private $currency;
  private $cart;
  private $shipping;

  public function __construct()
  {
    /* Get the shop currency set in panel
    and construct a new instance of the Currency class. */
    $kirby = kirby();
    $shop = $kirby->page('shop');

    if ($shop->currency()->isNotEmpty()) {
      $shopCurrency = $shop->currency()->value();
    } else {
      /* Default value */
      $shopCurrency = 'EUR';
    }

    $this->currency = new Currency($shopCurrency);
    $this->cart = new Cart();
    $this->shipping = new Shipping();
    $this->payments = new Payments();

    $this->session = $session = $kirby->session();

    $session->set('magasin.cart', []);
  }

  public function currency() {
    return $this->currency;
  }

  public function cart() {
    return $this->cart;
  }

  public function shipping() {
    return $this->shipping;
  }

  public function payments() {
    return $this->payments;
  }

  public function startPayement($cart) {
    $redirect = $this->payments->createStripeCheckoutSession($cart)->url;
    return $redirect;
  }
}
