<?php
namespace Wizhou\Magasin;

use Kirby\Cms\Page;

class ProductPage extends Page {

  public function prettyPrice() {
    return currency()->prettify($this->price_including_tax());
  }

  public function amount() {
    return currency()->toAmount($this->price_including_tax());
  }

  public function taxAmount() {
    $price = $this->price_before_tax()->toFloat();
    $tax = $this->tax()->toFloat();

    $taxAmount = $price * $tax / 100;
    return $taxAmount;
  }

  public function taxRate() {
    return $this->tax()->toFloat();
  }

  public function quantity() {
    return $this->stock()->toInt();
  }

  public function hasTax() {
    return $this->taxRate() != 0;
  }
}
