<?php
namespace Wizhou\Magasin;
use Wizhou\Magasin\Carrier;
use Kirby\Toolkit\Collection;
use Kirby\Cms\StructureObject;

class Shipping extends Collection
{

  protected $defaultCarrier;
  protected $shippingZone = 'France';

  public function __construct(array $data = []) {
    $kirby = kirby();

    $carriers = $kirby->page('carriers')->children()->listed();

    foreach ($carriers as $page) {
      try {
        $carrier = new Carrier($page);
        $this->append($page->id(), $carrier);

      } catch (\Exception $e) {
        throw new \Exception("Cannot build carrier", 1);
      }
    }

    $shop = $kirby->page('shop');
    if ($shop->default_carrier()->isNotEmpty()) {
      $defaultCarrier = $shop->default_carrier()->value();
    } else {
      /* Default value */
      $defaultCarrier = $this->first()->id();
    }
    $this->defaultCarrier = $defaultCarrier;
  }

  public function setDefaultCarrier ($id) {
    $this->defaultCarrier = $id;
  }

  public function editShippingZone ($zone) {
    $this->shippingZone = $zone;
  }

  public function tables () {
    $tables = [];

    foreach ($this as $carrier) {
      $tables[$carrier->id()] = $carrier->table()->toStructure();
    }

    $tables = new Collection ($tables);

    return $tables;
  }

  public function isFree ($carrier = null) {
    if (!$carrier) $carrier = $this->defaultCarrier;
    return $this->get($carrier)->freeShipping();
  }

  public function getShippingOptions ($cart) {
    $shippingOptions = new Collection;

    /* For Gargarisme = France. Je dois préparer une selection
    de la shipping zone en amont */
    $shippingZone = $this->shippingZone;

    if ($cart->isNotEmpty()) {
      foreach ($this as $carrier) {
        /* Get total price */
        $totalPrice = $cart->total();
        /* Get total weight */
        $totalWeight = $cart->totalWeight();

        /* Get the zones ranges for the given cart weight */
        $ranges = $carrier->findShippingPrice($totalPrice, $totalWeight);

        if ($ranges === 'free') {
          // $shippingOptions->append($carrier->id(), 'free');
          //
        } else if ($ranges) {
          foreach ($ranges as $range) {
            if ($range->zone() == $shippingZone) {
              $shippingOptions->append($carrier->id(), $range);
            }
          }
        }
      }
    }

    return $shippingOptions;
  }

  public function getShippingPrice ($cart, $carrier = null) {
    /* If no carrier are setted, select the default one */
    if (!$carrier) $carrier = $this->defaultCarrier;

    /* Get all options for the given cart weight or price */
    $shippingOptions = $this->getShippingOptions($cart);

    /* Get the option of the setted $carrier  */

    if ($shippingOptions->has($carrier)) {
      $carrierOption = $shippingOptions->get($carrier);
      $shippingPrice = $carrierOption->price()->toFloat();

    } else if ($shippingOptions->isNotEmpty()) {
      /* The setted carrier is not present in the options array */
      $carrierOption = $shippingOptions->first();
      $shippingPrice = $carrierOption->price()->toFloat();

    } else {
      /* Shipping options is Empty, there is no shipping avaliable */
      $shippingPrice = false;
    }

    /* Check if there is a price */
    if (is_float($shippingPrice)) {
      /* There is a shipping option, either for the setted
      carrier (default or given), or from another carrier. */
      return $shippingPrice;

    } else if ($shippingPrice === 0
    OR $shippingPrice === 0.00) {
      /* Shipping if free */
      return 0.00;

    } else {
      /* There is no shipping option avaliable. */
      return false;
    }
  }

}
