<?php
return function($site, $pages, $page) {
  $csrf = csrf();
  payments()::setStripeApiKey();

  /* Retrive info from Stripe */
  $session_id = get('session_id');
  $session = \Stripe\Checkout\Session::retrieve($session_id);
  $customer = \Stripe\Customer::retrieve($session->customer);
  $line_items = \Stripe\Checkout\Session::allLineItems($session_id);

  /* Create a collection with all the prodcuts from $line_items
  as Stripe Products. And, create a cart with the  */
  $checkoutCart = new Collection;
  foreach ($line_items->data as $lineItem) {
    $stripeProducId = $lineItem->price->product;

    $stripeProduc = \Stripe\Product::retrieve(
      $stripeProducId,
      []
    );

    $checkoutCart->append($stripeProduc);

    $productUuid = $stripeProduc->metadata->uuid;
    $prodcutPage = $site->page($productUuid);
  }

  /* Get customers infos */
  $name = $customer->name;
  $email = $customer->email;

  $customerAdress = $customer->address;

  $prettyCustomerAdress = [
    'line1' => $customerAdress->line1,
    'line2' => $customerAdress->line2,
    'postal_code' => $customerAdress->postal_code,
    'city' => $customerAdress->city,
    'state' => $customerAdress->state,
    'country' => $customerAdress->country
  ];

  $prettyCustomerAdress = join(' ', $prettyCustomerAdress);

  $shipping = $session->shipping;

  if ($shipping) {

    $shippingAdress = $shipping->address;

    $prettyShippingAdress = [
      'line1' => $shippingAdress->line1,
      'line2' => $shippingAdress->line2,
      'postal_code' => $shippingAdress->postal_code,
      'city' => $shippingAdress->city,
      'state' => $shippingAdress->state,
      'country' => $shippingAdress->country
    ];

    $prettyShippingAdress = join(' ', $prettyShippingAdress);
  } else {
    $prettyShippingAdress = $prettyCustomerAdress;
  }

  $totalDetails = $session->total_details;
  $amountShipping = $totalDetails->amount_shipping;

  $shipppingOptions = $session->shipping_options;
  $shipping_rate = '';
  foreach ($shipppingOptions as $shipppingOption) {
    if ($shipppingOption->shipping_amount == $amountShipping) {
      $shipping_rate = $shipppingOption->shipping_rate;
      $shipping_rate = \Stripe\ShippingRate::retrieve($shipping_rate);
      break;
    }
  }

  /*=============================================>>>>>
  = Create Order Page =
  ===============================================>>>>>*/

  /* Create an order page if the checkout-success page appear
  for the first time and store the data of the page. The stock is then updated inside the page.create.after hook.  */
  //
  // $orderId = Str::slug($session->id);
  // $orderYear = date('Y', $session->created);
  //
  // if (! $site->page('orders/' . $orderId)) {
  //
  //   $order = Page::create([
  //     'slug' => $orderId,
  //     'parent' => $site->page('orders'),
  //     'template' => 'order',
  //     'content' => [
  //       'year' => $orderYear,
  //       'session' => json_encode($session),
  //       'line_items' => json_encode($line_items),
  //       'customer' => json_encode($customer),
  //       'date' => date('Ymdhhsu', $session->created)
  //     ]
  //   ]);
  //
  //   $order = $order->changeStatus('listed');
  // }

  /*=============================================>>>>>
  = Flush Cart =
  ===============================================>>>>>*/

  /* Remove the cart session */
  cart()->flushCart();


  return compact(
    'session',
    'customer',
    'line_items',
    'name',
    'email',
    'prettyCustomerAdress',
    'shipping',
    'shippingAdress',
    'prettyShippingAdress',
    'shipping_rate',
    'checkoutCart',
  );
};
