<?php

return function ($newPage, $oldPage) {

  if ($newPage->template() == 'shop') {
    if ($oldPage->currency() !== $newPage->currency()) {
      currency()->setCurrencySymbolInBlueprints();
    }
  }

  if ($newPage->template() == 'product') {
    if ($newPage->price_calculator_method() == 'excluding_tax') {

      if ($oldPage->price_before_tax() !== $newPage->price_before_tax()) {
        $priceBeforeTax = $newPage->price_before_tax()->toFloat();
        $tax = $newPage->tax()->toInt();

        $priceIncludingTax = currency()::getPriceIncludingTax($priceBeforeTax, $tax);

        $newPage->update([
          'price_including_tax' => $priceIncludingTax
        ]);
      }

    } elseif ($newPage->price_calculator_method() == 'including_tax') {

      if ($oldPage->price_including_tax() !== $newPage->price_including_tax()) {

        $priceIncludingTax = $newPage->price_including_tax()->toFloat();
        $tax = $newPage->tax()->toInt();

        $priceBeforeTax = currency()::getPriceBeforeTax($priceIncludingTax, $tax);

        $newPage->update([
          'price_before_tax' => $priceBeforeTax
        ]);
      }
    }
  }
};
