<?php

use Wizhou\Magasin\Magasin;
use Wizhou\Magasin\Cart;
use Wizhou\Magasin\ProductPage;
use Wizhou\Magasin\Currency;
use Kirby\Cms\Page;
use Kirby\Exception\Exception;

@include_once __DIR__ . '/vendor/autoload.php';

function magasin (): Magasin {
  return new Magasin();
}

function product () {
  return new ProductPage;
}

function currency () {
  return magasin()->currency();
}

function cart () {
  return magasin()->cart();
}

function shipping () {
  return magasin()->shipping();
}

function payments () {
  return magasin()->payments();
}

Kirby::plugin('wizhou/magasin', [
  'options' => [
    'currency' => function () {
      return kirby()->page('shop')->currency()->value();
    },
    'production' => false,
    'stripe' => [
      'test' => [
        // 'publicKey' => 'pk_test_51H0PkQG36S8FcVP7N2DC2ZSAbR1LkPC7HECCF6LhUKXBtXI9TO9rddPaCsPxVwKm7JmR9TLF3nRQHjowXE9w1zgB00IYUTkFMR', // Romain Goetz
        // 'privateKey' => 'sk_test_51H0PkQG36S8FcVP7u7QCSzxEHzJGgKwESpjL8lrcXRhl4s4nPuenrEKoVwY4HvHGPkoRIaFAtWHlYydCxRqAEDo200iggJJuKT' // Romain Goetz
        'publicKey' => 'pk_test_51MU5z4D7KsNOL0Kz5OQ5mpIUPE24xRgS778WB5gUhptsuPN9sJvMiXuhqb9WtbJLmQIdzxeCY5CbYTVGmTbBPbMq00bVGMWzjb', // Gargarismes
        'privateKey' => 'sk_test_51MU5z4D7KsNOL0KzJqitz5b2dlZS4QGZ8IKORjtNAWHua3zkCHuBF0HG9s2Ted7CHBlrQ7cCnVLzSrcBhFkvvzSd00y2B6saKw' // Gargarismes
      ],
      'live' => [
        'publicKey' => 'pk_live_51MU5z4D7KsNOL0Kz7fKLZ33L8faNivrLhIut1wSml1JEJAMKiZpaQ0UJIMUlZEpgZGfaMRLPxy5imPYy2I9WGKNA00RqjKz2Lo',
        'privateKey' => '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'
      ]
    ],
    // 'stripeWebhooks' => 'whsec_mSQdxaM4x7iBgYvQhkM6E83br7DpBBHY' // Romain Goetz
    'stripeWebhooks' => 'whsec_9UXWZKYepzEKASwO1I16uImRGCqMh18q' // Romain Goetz
  ],
  'blueprints' => [
    'fields/dimension' => __DIR__ . '/blueprints/fields/dimension.yml',
    'fields/price' => __DIR__ . '/blueprints/fields/price.yml',
    'fields/shipping_table_range' => __DIR__ . '/blueprints/fields/shipping_table_range.yml',
    'fields/weight_table' => __DIR__ . '/blueprints/fields/weight_table.yml',

    'pages/shop' => __DIR__ . '/blueprints/pages/shop.yml',
    'pages/checkout' => __DIR__ . '/blueprints/pages/checkout.yml',
    'pages/cart' => __DIR__ . '/blueprints/pages/cart.yml',
    'pages/carrier' => __DIR__ . '/blueprints/pages/carrier.yml',
    'pages/carriers' => __DIR__ . '/blueprints/pages/carriers.yml',
    'pages/product' => __DIR__ . '/blueprints/pages/product.yml',
    'pages/zones' => __DIR__ . '/blueprints/pages/zones.yml',
    'pages/orders' => __DIR__ . '/blueprints/pages/orders.yml',
    'pages/order' => __DIR__ . '/blueprints/pages/order.yml',

    'tabs/quantity' => __DIR__ . '/blueprints/tabs/quantity.yml',
    'tabs/shipping' => __DIR__ . '/blueprints/tabs/shipping.yml',
    'tabs/shop_config' => __DIR__ . '/blueprints/tabs/shop_config.yml'
  ],
  'controllers' => [
    'checkout-success' => include_once __DIR__ . '/controllers/checkout-success.php',
  ],
  'pageModels' => [
    'product' => 'Wizhou\Magasin\ProductPage',
  ],
  'pageMethods' => include_once __DIR__ . '/methods/page.php',
  'routes' => include_once __DIR__ . '/routes/routes.php',
  'hooks' => include_once __DIR__ . '/hooks/hooks.php',
  'templates' => [
    'order' => __DIR__ . '/templates/order.php',
  ],
]);


 ?>
