<section class="cart-summary col-4 lead aperture">
  <div class="cart-summary-container">
    <div class="cart-summary-item cart-total row">
      <div class="col-6">
        <?= $cart->quantityOfItems(); ?> articles
      </div>
      <div class="col-6">
        <?= $cart->prettyTotal(); ?>
      </div>
    </div>
    <div class="cart-summary-item cart-shipping row">
      <div class="col-6">
        Livraison
      </div>
      <div class="col-6">
        <?php if($cart->isSafeForShipping()) {
          echo $cart->prettyShipping();
        } else if ($cart->isEmpty()) {
          echo $cart->prettyShipping();
        } else {
          echo 'Livraison impossible';
        } ?>
      </div>
    </div>
    <div class="cart-summary-item cart-total-with-shipping row">
      <div class="col-6">
        Total TTC
      </div>
      <div class="col-6">
        <?= $cart->prettyFinalTotal(); ?>
      </div>
    </div>
    <form
      action="<?= $site->page('checkout')->url(); ?>"
      method="POST"
    >
      <div class="form-check cicero">
        <input
          type="checkbox"
          class="form-check-input"
          id="termsConsent"
          v-model="consent"
        >
        <label
          class="form-check-label"
          for="termsConsent"
        >J'ai pris connaissance des <a href="<?= $kirby->page('terms/cvg')->url(); ?>">conditions générales de vente</a></label>
      </div>
      <input
        type="hidden"
        name="total"
        value="<?= $cart->total(); ?>"
      >
      <input
        type="hidden"
        name="shippingPrice"
        value="<?= $cart->shippingPrice(); ?>"
      >
      <input
        type="hidden"
        name="finalTotal"
        value="<?= $cart->finalTotal(); ?>"
      >
      <?php if ($cart->isEmpty()
      || $cart->isNotSafeForShipping()): ?>
        <button
          type="submit"
          class="button button-primary button-unmarged col-12"
          disabled
        >
          Commander
        </button>
      <?php else: ?>
        <button
          type="submit"
          class="button button-primary button-unmarged col-12"
          :disabled="!consent"
        >
          Commander
        </button>
      <?php endif; ?>

    </form>
  </div>
</section>
