<?php if ($pagination->hasPages()): ?>
  <nav class="pagination">
    <ul class="pagination-list list list-inline row justify-content-center align-items-center">

      <li class="list-inline-item">
        <a
          class="button button-circle button-icon <?php if (!$pagination->hasPrevPage()) echo 'is-disabled' ?>"
          href="<?= $pagination->prevPageURL() ?>"
          <?php if (!$pagination->hasPrevPage()) echo 'disabled' ?>
        >
          <span class="icon-navigate_before"></span>
        </a>
      </li>

      <?php foreach ($pagination->range(10) as $r): ?>
      <li class="list-inline-item">
        <a
          class="button button-clean button-icon button-tag"
          <?= $pagination->page() === $r ? ' data-active="true"' : '' ?>
          href="<?= $pagination->pageURL($r) ?>"
        >
          <?= $r ?>
        </a>
      </li>
      <?php endforeach ?>

      <li class="list-inline-item">
        <a
          class="button button-circle button-icon <?php if (!$pagination->hasNextPage()) echo 'is-disabled' ?>"
          href="<?= $pagination->nextPageURL() ?>"
          <?php if (!$pagination->hasNextPage()) echo 'disabled' ?>
        >
          <span class="icon-navigate_next"></span>
        </a>
      </li>
    </ul>
  </nav>
  <?php endif ?>
