<div class="shop-item aperture col-3">
  <a
    href="<?= $product->url(); ?>"
    class="shop-item-link"
  >
    <div class="shop-item-cover">
      <?php if($cover = $product->getCover('shopCoverImage')): ?>
        <img
          src="<?= $cover['src']; ?>"
          srcset="<?= $cover['srcset']; ?>"
          alt="<?= $cover['alt']; ?>"
          class="lazyload"
          data-src="<?= $cover['src']; ?>"
          data-srcset="<?= $cover['srcset']; ?>"
        >
        <div class="help">
          <span class="icon-remove_red_eye"></span>
          Découvrir
        </div>
      <?php endif; ?>
    </div>
    <div class="shop-item-body">
      <h3 class="headings headings-unmarged">
        <?= $product->title(); ?>
      </h3>
      <ul class="authors list list-inline lead">
        <?php foreach ($product->authors()->toPages() as $author): ?>
          <li class="author list-inline-item">
            <?= $author->title(); ?>
            <?php if ($author != $product->authors()->toPages()->last()): ?>&emsp14;&amp;<?php endif; ?>
          </li>
        <?php endforeach; ?>
      </ul>
    </div>
    <div class="shop-item-footer row">
      <?php if ($product->categories()->isNotEmpty()): ?>
        <span class="shop-item-category button button-tag button-unmarged button-inline-block <?= $product->categories()->toPage()->button(); ?>">
          <?= $product->categories()->toPage()->title(); ?>
        </span>
      <?php endif; ?>
      <div class="shop-item-price headline">
        <?= $product->prettyPrice(); ?>
      </div>
    </div>
  </a>
</div>
