<?php snippet('layout', slots: true); ?>

<?php slot('content'); ?>
  <main class="flow author">
    <div class="author-container row justify-content-center content">
      <section class="author-content col-10">
        <div class="author-header aperture">
          <?php snippet('components/page-title'); ?>
        </div>
        <div class="author-text">
          <?php foreach ($page->text()->toBlocks() as $block): ?>
            <div
              id="<?= $block->id() ?>"
              class="block block-type-<?= $block->type(); ?>"
            >
              <?= $block ?>
            </div>
          <?php endforeach; ?>
        </div>
      </section>
      <section class="author-prints col-12">
        <hr>
        <h3 class="headings author-prints-headings">Réalisations</h3>
        <?php if($prints->count() > 0): ?>
        <ul class="author-prints-list list list-inline row">
          <?php foreach ($prints as $print): ?>
            <?php snippet('components/author-print', [
              'print' => $print
            ]); ?>
          <?php endforeach; ?>
          <?php if ($prints->count() % 4 != 0): ?>
            <?php $missing = $page->getNumberOfMissingItem($prints, 4); ?>
            <?php for ($i=0; $i < $missing; $i++): ?>
              <?php snippet('components/author-print-empty') ?>
            <?php endfor; ?>
          <?php endif; ?>
        </ul>
      <?php else: ?>
        <div class="author-no-prints row justify-content-center">
          <div class="info-empty col-6">
            <span class="icon icon-print_disabled"></span> Pas encore de réalisations
          </div>
        </div>
      <?php endif; ?>
      </section>
      <div class="author-back-button row justify-content-center">
        <hr class="col-12">
        <a
          href="<?= $page->parent()->url(); ?>"
          class="button button-tertiary button-inline-block"
        >Retour aux auteurs et autrices</a>
      </div>
    </div>
  </main>
<?php endslot(); ?>