<?php snippet('layout', slots: true); ?>

<?php slot('content'); ?>
  <main class="flow cart">
    <div class="cart-container row">
      <section class="cart-items col-8 aperture">
        <div class="cart-items-container">
          <h1 class="h2 headings headings-unmarged">
            <?= $page->title(); ?>
          </h1>
          <?php if ($cart->isNotEmpty()): ?>
            <ul class="cart-items-list list-unstyled">
              <?php foreach ($cart as $product): ?>
                <?php snippet('components/cart-item', [
                  'product' => $product
                ]); ?>
              <?php endforeach; ?>
            </ul>
          <?php else: ?>
            <?php snippet('components/cart-empty'); ?>
          <?php endif; ?>
        </div>
        <div class="cart-items-footer">
          <div class="cart-items-backbutton">
            <a
              class="button button-clean button-inline-block back-button"
              href="<?= $site->page('shop')->url(); ?>"
            ><span class="icon-navigate_before"></span> Continuer mes achats</a>
          </div>
        </div>
      </section>
      <?php snippet('components/cart-summary'); ?>
    </div>
    <?php if ($cart->isNotSafeForShipping()): ?>
      <div class="info aperture marge">
        <?php if ($cart->isNotSafeForShipping()): ?>
          Votre panier ne peut pas être livré avec nos conditions normales de livraison. Merci de nous <a href="mailto:<?= $site->mail(); ?>">contacter par email</a> avec les produits que vous souhaitez commander et nous trouverons une solution adaptée.
        <?php endif; ?>
      </div>
    <?php endif; ?>
    <?php if ($cart->isNotEmpty()): ?>
      <hr>
      <?php snippet('components/cart-assurance'); ?>
    <?php endif; ?>
  </main>
<?php endslot(); ?>
