<?php snippet('start'); ?>
<?php snippet('header'); ?>
<?php snippet('components/hero'); ?>
<main class="checkout flow">
  <section class="checkout-introduction aperture">
    <h1 class="headings">👍 Wohoou, merci !</h1>
    <p class="headline">Merci pour votre commande <strong><?= $name ?></strong>.<br>Nous vous enverrons un mail de confirmation à <strong><?= $email; ?></strong> dans les plus brefs délais.</p>
    <p class="lead">Retrouvez le récapitulatif de votre commande sur cette page. Si vous avez la moindre question, n'hésitez pas à nous <a href="mailto:<?= $site->mail(); ?>">contacter par email</a>.</p>
    <hr>
  </section>
  <section class="checkout-success">
    <div class="order-infos row">
      <div class="date col-6 lead aperture">
        <span class="h3"><strong>Date</strong></span> : 
        <?= date('d/m/Y', $session->created); ?>
      </div>
    </div>
    <div class="customer row">
      <div class="billing-adress col-4 lead aperture">
        <h3>Adresse de facturation</h3>
        <p><?= $name; ?><br>
        <?= $prettyCustomerAdress; ?></p>
      </div>

      <div class="shipping-adress col-4 lead aperture">
        <h3>Adresse de livraison</h3>
        <p><?= $shipping->name; ?><br>
        <?= $prettyShippingAdress; ?></p>
      </div>

      <div class="shipping-option col-4 lead aperture">
        <h3>Option de livraison</h3>
        <p>
          <?= $shipping_rate->display_name; ?><br>
          <?php $shippingAmount = $shipping_rate->fixed_amount->amount;
          echo currency()->prettify($shippingAmount, 'amount'); ?>
          <br>
          <span class="cicero">
            <?php if ($shipping_rate->delivery_estimate): ?>
              <?php if ($shipping_rate->delivery_estimate->maximum->value == $shipping_rate->delivery_estimate->minimum->value): ?>
                Livraison en <?= $shipping_rate->delivery_estimate->minimum->value; ?> jours.
              <?php else: ?>
                Livraison en <?= $shipping_rate->delivery_estimate->minimum->value; ?> à <?= $shipping_rate->delivery_estimate->maximum->value; ?> jours.
              <?php endif; ?>
            <?php endif; ?>
          </span>
        </p>
      </div>
    </div>

    <div class="checkout-summary aperture">
      <div class="interspace"></div>
      <h3>Résumé de la commande</h3>
      <table class="checkout-table">
        <tr>
          <th>Nom du produit</th>
          <th>Prix unitaire</th>
          <th>Quantité</th>
          <th>Prix TTC</th>
        </tr>
        <?php foreach ($checkoutCart as $id => $product): ?>
          <?php $uuid = $product->metadata->uuid;
          $page = $site->page($uuid);
          $lineItem = $line_items->data[$id];
          ?>
          <tr>
            <td><strong><?= $page->title(); ?></strong></td>
            <td align="right"><?= Currency()->prettify($lineItem->amount_subtotal, 'amount'); ?></td>
            <td align="right"><?= $lineItem->quantity; ?></td>
            <td align="right"><?= Currency()->prettify($lineItem->amount_total, 'amount'); ?></td>
          </tr>
        <?php endforeach; ?>
        <tr>
          <td colspan="3" align="right">Sous-total</td>
          <td align="right"><?= Currency()->prettify($session->amount_subtotal, 'amount'); ?></td>
        </tr>
        <tr>
          <td colspan="3" align="right">Livraison</td>
          <td align="right"><?= Currency()->prettify($session->total_details->amount_shipping, 'amount'); ?></td>
        </tr>
        <tr>
          <td colspan="3" align="right"><strong>Total</strong></td>
          <td align="right"><strong><?= Currency()->prettify($session->amount_total, 'amount'); ?></strong></td>
        </tr>
      </table>
    </div>
  </section>
  <section class="checkout-footer aperture">
    <a
      class="button button-primary button-inline-block button-unmarged lead"
      href="<?= $site->url(); ?>"
    >Retour à l'accueil</a>
    <a
      class="button button-secondary button-inline-block lead"
      onclick="window.print()"
    >Imprimer</a>
  </section>
  <div class="interspace"></div>

</main>
<?php snippet('components/headband'); ?>
<?php snippet('components/socials'); ?>
<?php snippet('footer') ?>
<?php snippet('end'); ?>
