<?php snippet('layout', slots: true); ?>

<?php slot('content'); ?>
  <main class="product">
    <section class="product-container row">
      <div class="product-cover col-6">
        <?php snippet('components/gallery'); ?>
      </div>
      <div class="product-content content col-6">
        <div class="product-back-link">
          <?php snippet('components/button-back-to-shop'); ?>
        </div>
        <div class="product-headings">
          <h1 class="headings headings-unmarged">
            <?= $page->title(); ?>
          </h1>
        </div>
        <ul class="product-authors list list-inline lead">
          <?php foreach ($authors as $author): ?>
            <li class="product-author list-inline-item headline">
              <a
                href="<?= $author->url(); ?>"
                class="product-author-link"
              ><?= $author->title(); ?></a>
              <?php if ($authors->last() != $author): ?>
                <span>&emsp14;&amp;&emsp14;</span>
              <?php endif; ?>
            </li>
          <?php endforeach; ?>
        </ul>
        <div class="product-text">
          <?= $page->text()->toBlocks(); ?>
        </div>
        <div class="product-tags">
          <?php foreach ($page->tags()->split(',') as $tag): ?>
            <span class="product-tag"><?= $tag; ?></span>
          <?php endforeach; ?>
        </div>
        <hr>
        <div class="product-footer">
          <app-button-add-to-cart
            :cart="cart"
            price='<?= Escape::attr($page->prettyPrice()); ?>'
            :stock='<?= Escape::attr($page->stock()->toInt()); ?>'
            id='<?= Escape::attr($page->id()); ?>'
            @update-cart='updateCart'
            @cart-modal='productIsAddedIntoCart = true'
          ></app-button-add-to-cart>

          <app-cart-modal
            id='<?= Escape::attr($page->id()); ?>'
            :cover='<?= json_encode($page->getCover()); ?>'
            title='<?= Escape::attr($page->title()); ?>'
            :cart="cart"
            :locale-settings="localeSettings"
            :modal-is-active="productIsAddedIntoCart"
            @close="productIsAddedIntoCart = false"
          ></app-cart-modal>
        </div>
        <hr>
        <div class="product-share row align-items-center">
          <span class="text">Partager :</span>
          <?php snippet('components/button-share-group'); ?>
        </div>
      </div>
    </section>
    <section class="similar-products row">
      <span class="decorative-line"></span>
      <?php foreach ($similar as $item): ?>
        <?php snippet('components/shop-item', [
          'product' => $item
        ]); ?>
      <?php endforeach; ?>
    </section>
  </main>
<?php endslot(); ?>
