<?php
$json = [];
$kirby = kirby();
$request = $kirby->request();
$page = $kirby->page('shop');
$limit = $page->paginationLimit()->toInt();
$products = $page->children()->sortBy('date', 'desc');
$page = null;

if ($request->method() == 'POST') {
  $category = get('category');
  $sorting = get('sorting');

  if ($category) {
    $categories = $site->page('categories')->children();
    $key = $categories->findBy('slug', $category)->id();

    $products = $products->filter('categories', '==', $key);
  }

  if ($sorting) {
    switch ($sorting) {
      case 'newest':
        $products = $products->sortBy('date', 'desc');
        break;

      case 'oldest':
        $products = $products->sortBy('date', 'asc');
        break;

      case 'priciest':
        $products = $products->sortBy('price_including_tax', 'desc');
        break;

      case 'cheapest':
        $products = $products->sortBy('price_including_tax', 'asc');
        break;

      case 'preoder':
        $products = $products->filter('is_in_preorder', '==', 'true');
        break;
    }
  }
}

$products = $products->paginate($limit);

$pagination = $products->pagination();

$json['data']  = [];
$json['pages'] = $pagination->pages();
$json['page']  = $pagination->page();

foreach ($products as $product) {
  $json['data'][$product->id()] = [
    'page' => $product->toArray(),
    'authors' => $product->authors()->toPages()->pluck('title', true),
    'pretty_price' => (string)$product->prettyPrice(),
    'cover' => $product->getCover('shopCoverImage'),
    'category' => [
      'button' => $product->categories()->toPage()->button(),
      'title' => (string)$product->categories()->toPage()->title()
    ],
  ];
}

echo json_encode($json);
 ?>
