import { createApp } from 'vue';
import anime from 'animejs/lib/anime.es.js';
import 'lazysizes';
import 'lazysizes/plugins/attrchange/ls.attrchange';
import axios from 'axios';
import ScrollOut from 'scroll-out';

import AppHeader from './components/AppHeader.vue';
import AppMapBox from './components/AppMapBox.vue';
import AppGallery from './components/AppGallery.vue';
import AppShop from './components/AppShop.vue';
import AppModal from './components/AppModal.vue';
import AppCartModal from './components/AppCartModal.vue';
import AppButtonAddToCart from './components/AppButtonAddToCart.vue';
import AppHomeShopCarrousel from './components/AppHomeShopCarrousel.vue';
import PhotoSwipeLightbox from './components/PhotoSwipeLightbox.vue';

const app = createApp({
  el: '#app',

  data () {
    return {
      name: 'Gargarismes',
      localeSettings: {
        locale: 'fr-FR',
        currency: 'EUR',
        maximumFractionDigits: 2
      },
      isMobileMenuVisible: false,
      isMounted: false,
      cart: {
        data: {},
        quantityOfItems: 0,
        total: 0,
        taxTotal: 0,
        shippingTotal: 0,
        finalTotal: 0
      },
      productIsAddedIntoCart: false,
      shippingIsSafe: true,
      consent: false
    };
  },

  components: {
    AppHeader,
    AppMapBox,
    AppGallery,
    AppShop,
    AppModal,
    AppCartModal,
    AppButtonAddToCart,
    AppHomeShopCarrousel,
    PhotoSwipeLightbox
  },

  methods: {

    updateCart: function (data) {
      this.cart.data = data.cart;
      this.cart.quantityOfItems = data.quantity_of_items;
      this.cart.total = data.total;
      this.cart.taxTotal = data.tax_total;
      this.cart.shippingTotal = data.shipping_total;
      this.cart.finalTotal = data.final_total;
    },

    getCart: function () {
      const url = new URL(window.location.origin + '/getCart');

      axios({
        method: 'GET',
        url: url,
        headers: { 'X-Requested-With': 'XMLHttpRequest' }
      })
        .then((response) => {
          console.log(response.data, 'Cart');
          const data = response.data;
          this.updateCart(data);
        });
    }
  },

  mounted: function () {
    this.isMounted = true;
    this.getCart();

    ScrollOut({
      targets: '.header',
      offset: 100
    });
    // anime({
    //   targets: '.anime-grow-background',
    //   filter: ['hue-rotate(0deg)', 'hue-rotate(360deg)'],
    //   loop: true,
    //   direction: 'alternate',
    //   duration: 50000,
    //   easing: 'linear'
    // });

    // anime({
    //   targets: '.decorative-line',
    //   'background-position': ['0px', '2450px'],
    //   loop: true,
    //   direction: 'reverse',
    //   duration: 50000,
    //   easing: 'linear'
    // });
  }
});

app.mount('#app');


window.addEventListener('load', function(event) {
  /* Hide the loader once the page have been fully loaded. */

  /* Select the loading div container */
  const loading = document.getElementById('loading');

  /* Apply the hiding class to the div */
  loading.classList.add('hide');

  window.setTimeout(() => {
    /* Remove the loader */
    loading.parentElement.removeChild(loading);
  }, 1000);
});
