---
layout: home
---

<div class="interspace"></div>
<section>
  <div class="aperture">
    <p><code>coeur-de-fer</code> is a tool written in <a href="https://lesscss.org">{less}</a> intended to concieve <strong>customized CSS Frameworks</strong>. It purpose is to help build easier and quicker CSS for frontend webdesign, with simple, extensive et extendable components to mix and use. It is intended to be used on <strong>conception level</strong>.</p>

    <p>It's not assuming which component you will be using, on the contrary, this tool is about helping you <strong>build the components you need</strong>.</p>

    <p>On a practical level, <code>coeur-de-fer</code> is a library of Less <strong>mixins</strong> and <strong>functions</strong> aiming at framework creation. They handle common and precise CSS processing for <strong>layout</strong>, <strong>paint</strong> and <strong>composite</strong> stage of design.</p>
  </div>
  <div class="rule"></div>
</section>
<div class="row">
  <div class="aperture col-6 col-tablet-12">
    <h4 class="headings headings-unmarged-top">
      Installation
    </h4>
    <p>Install <code>coeur-de-fer</code> source Less files via <code>npm</code> or <code>git submodule</code>. The shipped package will be ready to be use directly on your project.</p>
    <a class="button button-inline-block button-primary button-unmarged" href="{{ '/docs/introduction' | relative_url }}">Read installation docs</a>
  </div>
  <div class="aperture col-6 col-tablet-12">
    <pre><code class="language-bash">npm i @wizhou/coeur-de-fer</code></pre>
    <pre><code class="language-bash">git submodule add https://github.com/wizhou/coeur-de-fer.git coeur-de-fer</code></pre>
  </div>
  <div class="rule"></div>
</div>
<div class="row">
  <div class="aperture col-6 col-tablet-12">
    <h4 class="headings headings-unmarged-top">
      Quickstep
    </h4>
    <p>the easiest way to use the library is by importing it into your <code>index.less</code> file before anything else.</p>
  </div>
  <div class="aperture col-6 col-tablet-12">
    <pre><code class="language-less">@import (less) '{path-to-coeur-de-fer}/index.less';</code></pre>
  </div>

  <div class="rule"></div>
</div>
<div class="row">
  <div class="aperture col-4 col-tablet-12">
    <h4 class="headings headings-unmarged-top">
      Documentation
    </h4>
    <p>Dig deeper into <strong>our documentation</strong> to know how Cœur-de-fer work and what you can do with it.</p>
    <a class="button button-inline-block button-primary button-unmarged" href="{{ '/docs/introduction' | relative_url }}">Check the docs</a>
  </div>
  <div class="rule show-tablet"></div>
  <div class="aperture col-4 col-tablet-12">
    <h4 class="headings headings-unmarged-top">
      References
    </h4>
    <p>Check the cheatsheet of all <strong>mixin</strong> and <strong>function</strong> of Cœur-de-fer to a fast yet documented usage.</p>
    <a class="button button-inline-block button-primary button-unmarged" href="{{ '/docs/introduction' | relative_url }}">See the references</a>
  </div>
  <div class="rule show-tablet"></div>
  <div class="aperture col-4 col-tablet-12">
    <h4 class="headings headings-unmarged-top">
      Blog
    </h4>
    <p>Check out the news and where the developpement of Coeur-de-fer is heading.</p>
    <a class="button button-inline-block button-primary button-unmarged" href="{{ '/blog' | relative_url }}">Read the blog</a>
  </div>
</div>
