<?php
return function($site, $pages, $page) {

  $kirby = kirby();
  if ($kirby->request()->method() == 'POST') {
    $data = kirby()->request()->data();

    // Create Quote Id
    $date = date('Y-m-d H:i:s');

    $projectName = $data['project']['title'];
    if ($projectName === '') $projectName = 'Sans titre';

    $quoteID = $date . '/' . $data['personnalInfo']['last'] . '/' . $projectName;

    $quoteID = Str::slug($quoteID);

    $quotePage = page($page->slug() . '/' . $quoteID);
    if (!$quotePage) {

    $projectPaper = [];
    foreach ($data['projectPapers'] as $index => $paper) {
      if ($paper['isActive'] === true) {
        $projectPaper[$index] = $paper;
        $selectedPaperIndex = $projectPaper[$index]['paperSelect'];
        $projectPaper[$index]['selectedPaper'] =
        $page->papers()->toStructure()->get($selectedPaperIndex)->toArray();
      }
    }

    $kirby->impersonate('kirby', function () use ($quoteID, $page, $data, $quotePage, $projectName, $projectPaper, $kirby) {

      $quotePage = Page::create([
        'slug' => $quoteID,
        'parent' => $page,
        'template' => 'quote-request',
        'content' => [
          'date' => date('Y-m-d H:i:s'),
          'title' => $projectName,
          'details' => $data['project']['details'],

          'projectDetails' => [
            'category' => $data['project']['category'],
            'format' => $data['project']['format'],
            'folding' => $data['project']['folding'],
            'binding' => $data['project']['binding'],
            'quantity' => $data['project']['quantity'],
          ],

          'personal' => [
            'firstName' => $data['personnalInfo']['first'],
            'lastName' => $data['personnalInfo']['last'],
            'email' => $data['personnalInfo']['email'],
            'address' => $data['personnalInfo']['address'],
            'zip' => $data['personnalInfo']['zip'],
            'city' => $data['personnalInfo']['city'],
            'country' => $data['personnalInfo']['country'],
            'consent' => $data['personnalInfo']['consent'],
          ],

          'additionalsFields' => $data['additionalsFields'],
          'projectPapers' => $projectPaper,
        ]
      ]);

      $kirby->email([
        'from' => site()->mail()->value(),
        'to' => $data['personnalInfo']['email'],
        'subject' => 'Votre demande de devis!',
        'template' => 'quote-confirm',
        'data' => [
          'name' =>  $data['personnalInfo']['first'] . ' ' .  $data['personnalInfo']['last'],
          'siteEmail' => site()->mail(),
          'date' => date('Y-m-d H:i:s'),
          'title' => $projectName,
          'details' => $data['project']['details'],
          'category' => $data['project']['category'],
          'format' => $data['project']['format'],
          'folding' => $data['project']['folding'],
          'binding' => $data['project']['binding'],
          'quantity' => $data['project']['quantity'],
          'projectPapers' => $projectPaper,
          'firstName' => $data['personnalInfo']['first'],
          'lastName' => $data['personnalInfo']['last'],
          'email' => $data['personnalInfo']['email'],
          'address' => $data['personnalInfo']['address'],
          'zip' => $data['personnalInfo']['zip'],
          'city' => $data['personnalInfo']['city'],
          'country' => $data['personnalInfo']['country'],
        ]
      ]);

      $kirby->email([
        'from' => site()->mail()->value(),
        'to' => site()->mail()->value(),
        'subject' => 'Nouvelle demande de devis de la part de ' . $data['personnalInfo']['first'] . ' ' .  $data['personnalInfo']['last'],
        'template' => 'quote-inform',
        'data' => [
          'siteUrl' => site()->url(),
          'name' =>  $data['personnalInfo']['first'] . ' ' .  $data['personnalInfo']['last'],
          'siteEmail' => site()->mail(),
          'date' => date('Y-m-d H:i:s'),
          'title' => $projectName,
          'details' => $data['project']['details'],
          'category' => $data['project']['category'],
          'format' => $data['project']['format'],
          'folding' => $data['project']['folding'],
          'binding' => $data['project']['binding'],
          'quantity' => $data['project']['quantity'],
          'projectPapers' => $projectPaper,
          'firstName' => $data['personnalInfo']['first'],
          'lastName' => $data['personnalInfo']['last'],
          'email' => $data['personnalInfo']['email'],
          'address' => $data['personnalInfo']['address'],
          'zip' => $data['personnalInfo']['zip'],
          'city' => $data['personnalInfo']['city'],
          'country' => $data['personnalInfo']['country'],
        ]
      ]);
    });

    }
  }


  $papers = [];
  foreach ($page->papers()->toStructure() as $id => $paper) {

    $weights = [];
    foreach ($paper->weight()->toStructure() as $weight) {
      $weights[] = $weight->name()->value();
    }

    $papers[$id] = [
      'name' => $paper->name()->value(),
      'price' => $paper->price()->value(),
      'slug' => $paper->name()->slug()->value(),
      'weights' => $weights
    ];
  }

  $colors = [];
  foreach ($page->colors()->toStructure() as $id => $color) {
    $colors[$id] = [
      'name' => $color->name()->value(),
      'code' => $color->code()->value(),
      'slug' => $color->name()->slug()->value()
    ];
  }

  $additionals = [];
  foreach ($page->additional_fields()->toStructure() as $id => $field) {
    $additionals[$id] = [
      'type' => $field->type()->value(),
      'name' => $field->name()->value(),
      'text' => $field->text()->value(),
      'id' => $field->id(),
      'options' => $field->options()->toArr()->value(),
    ];
  }

  return compact(
    'papers',
    'colors',
    'additionals'
  );
};
