<?php
namespace Wizhou\Magasin;

class Carrier
{

  private $id;
  private $trackingUrl;
  private $weightLimit;
  private $maxDimensions;
  private $priceTable;
  private $weightTable;
  private $freeShipping;
  private $outOfTableRange;
  private $sizeOrPrice;
  private $table;

  public function __construct($page) {
    if (!$page) {
      return false;
    }

    if (is_string($page)) {
      try {
        $page = kirby()->site()->page($page);
      } catch (\Exception $e) {
        throw new \Error("Page doesn't exist", 1);
      }
    }

    if ($page->intendedTemplate()->name() !== 'carrier') {
      throw new \Error("Page is not a carrier page", 1);
    }

    /* Add Id to the item */
    if ($page->id()) {
      $this->id = $page->id();
    } else {
      throw new \Error("Carrier has no id", 1);
    }

    if ($page->tracking_url()->isNotEmpty()) {
      $this->trackingUrl = $page->tracking_url()->value();
    }

    if ($page->weight_limit()->isNotEmpty()) {
      $this->weightLimit = $page->weight_limit()->value();
    } else {
      throw new \Error("Carrier has no weight limit", 1);
    }

    if ($page->dimensions_limit()->isNotEmpty()) {
      $this->maxDimensions = $page->dimensions_limit()->value();
    } else {
      throw new \Error("Carrier has no dimensions limit", 1);
    }

    if ($page->free_shipping()->isNotEmpty()) {
      $this->freeShipping = $page->free_shipping()->toBool();
    } else {
      throw new \Error("Free shipping toggle is not set for Carrier", 1);
    }

    if ($page->out_of_table_range()->isNotEmpty()) {
      $this->outOfTableRange = $page->out_of_table_range()->value();
    } else {
      throw new \Error("Out of range rule is not set for Carrier", 1);
    }

    if ($page->size_or_price()->isNotEmpty()) {
      $this->sizeOrPrice = $page->size_or_price()->value();
    } else {
      throw new \Error("Size of Price is not set for Carrier", 1);
    }

    if ($page->price_table()->isNotEmpty()) {
      $this->priceTable = $page->price_table()->toStructure();
    }

    if ($page->weight_table()->isNotEmpty()) {
      $this->weightTable = $page->weight_table()->toStructure();
    }

    if ($this->sizeOrPrice) {
      switch ($this->sizeOrPrice) {
        case 'total_price':
          $this->table = $this->priceTable;
          break;

        case 'total_weight':
          $this->table = $this->weightTable;
          break;
      }
    } else {
      throw new Exception("Table couldn't be setted", 1);
    }
  }

  public function id () {
    return $this->id;
  }

  public function table () {
    return $this->table;
  }

  public function maxDimensions () {
    return $this->maxDimensions;
  }

  public function freeShipping () {
    return $this->freeShipping;
  }

  /* Check if the product weight is within the carrier's range. */

  public function checkWeight ($weight) {
    if ($weight >= $this->weightLimit) {
      return false;
    } else {
      return true;
    }
  }

  public function checkProductDimensions ($CartItem) {
    $itemWidth = $CartItem->width();
    $itemHeight = $CartItem->height();
    $itemDepth = $CartItem->productDepth();
    $itemDimensions = $itemWidth + $itemHeight + $itemDepth;

    if ($itemDimensions >= $this->maxDimensions) {
      return false;
    } else {
      return true;
    }
  }

  public function isShippingFree () {
    return $this->freeShipping();
  }

  public function findShippingPrice ($price, $weight) {
    if ($this->isShippingFree()) {
      return 'free';
    }

    if ($this->sizeOrPrice === 'total_weight') {
      $cartWeight = $weight;
      $table = $this->table;

      foreach ($table as $range) {
        /* Get both weight to compare with the current cart weight */
        $weight_inferior = $range->weight_inferior()->toFloat();
        $weight_superior = $range->weight_superior()->toFloat();

        if ($cartWeight >= $weight_inferior
        && $cartWeight < $weight_superior) {
          $zones = $range->range()->toStructure();
          return $zones;
        }
      }
    } else if ($this->sizeOrPrice === 'total_price') {

    }
  }

  public function toPage() {
    return kirby()->site()->page($this->id());
  }
}
