<?php
namespace Wizhou\Magasin;
use Wizhou\Magasin\Currency;
use Wizhou\Magasin\Cart;
use Stripe\Stripe;
use Stripe\Charge;
use Stripe\Source;
use Stripe\ApiResource;

class Payments
{
  static function setStripeApiKey(): void {
    $kirby = kirby();

    if ($kirby->option('wizhou.magasin.production') === true) {
      $apiKey = $kirby->option('wizhou.magasin.stripe.live.privateKey');
      Stripe::setApiKey($apiKey);
    } else {
      $apiKey = $kirby->option('wizhou.magasin.stripe.test.privateKey');
      Stripe::setApiKey($apiKey);
    }
  }

  private static function stripeLineItems($cart) {
    $currency = currency()->ISO();
    $lineItems = [];
    foreach ($cart as $item) {
      $lineItems[] = [
        'price_data' => [
          'currency' => $currency,
          'product_data' => [
            'name' => $item->toPage()->title()->value(),
            'images' => [$item->toPage()->getCover()['url']],
            'metadata' => [
              'id' => $item->toPage()->id(),
              'uuid' => $item->toPage()->uuid()
            ]
          ],
          'unit_amount' => $item->amount(),
          'tax_behavior' => 'inclusive'
        ],
        'quantity' => $item->quantity()
      ];
    }

    return $lineItems;
  }

  private static function stripeShippingOptions($cart) {
    $shippingOptions = [];

    foreach (shipping()->getShippingOptions($cart) as $id => $carrier) {
      $currency = currency()->ISO();


      $additionalPrice = $additionalPrice = $cart->getAdditionalShippingPrice();
      $price = currency()->toAmount($carrier->price()->toFloat() + $additionalPrice);


      $shippingOptions[] = [
        'shipping_rate_data' => [
          'type' => 'fixed_amount',
          'fixed_amount' => [
            'amount' => $price,
            'currency' => $currency,
          ],
          'display_name' => shipping()->get($id)->toPage()->title(),
          'delivery_estimate' => [
            'minimum' => [
              'unit' => 'business_day',
              'value' => shipping()->get($id)->toPage()->minimum_delivery_estimate()->toInt(),
            ],
            'maximum' => [
              'unit' => 'business_day',
              'value' => shipping()->get($id)->toPage()->maxium_delivery_estimate()->toInt(),
            ],
          ]
        ]
      ];
    }

    $shippingOptions[] = [
      'shipping_rate_data' => [
        'type' => 'fixed_amount',
        'fixed_amount' => [
          'amount' => 0,
          'currency' => $currency,
        ],
        'display_name' => 'Récupération à Gargarisme',
      ]
    ];

    return $shippingOptions;
  }

  public static function createStripeCheckoutSession($cart) {
    $kirby = kirby();
    $currency = currency()->ISO();
    self::setStripeApiKey();

    $successUrl = $kirby->page('/checkout/success')->url();
    $cancelUrl = $kirby->page('/checkout/cancel')->url();

    $checkout_session = \Stripe\Checkout\Session::create([
      'billing_address_collection' => 'required',
      'shipping_address_collection' => [
        'allowed_countries' => ['FR'],
      ],
      'shipping_options' => self::stripeShippingOptions($cart),
      'line_items' => self::stripeLineItems($cart),
      'phone_number_collection' => [
        'enabled' => true,
      ],
      'mode' => 'payment',
      'success_url' => $successUrl . '?session_id={CHECKOUT_SESSION_ID}',
      'cancel_url' => $cancelUrl
    ]);

    return $checkout_session;
  }

  public static function createTaxRate() {
    $kirby = kirby();
    $currency = currency()->ISO();
    $apiKey = self::setStripeApiKey();
    $stripe = new \Stripe\StripeClient($apiKey);

    $taxRateID = $stripe->taxRates->create(
      [
        'display_name' => 'TVA',
        'inclusive' => true,
        'percentage' => 0,
        'country' => 'FR',
        'jurisdiction' => 'FRA',
        'description' => 'TVA',
      ]
    );

    return $taxRateID;
  }

  public static function createStripePaymentIntent(float $amount, array $params = [], $options = []): ApiResource {
    // self::setStripeApiKey();
    //
    // // $intent = \Stripe\PaymentIntent::create(
    // //   array_merge([
    // //     'amount' => $amount * 100,
    // //     'currency' => option('ww.merx.currency'),
    // //     'capture_method' => 'manual',
    // //     'payment_method_types' => ['card'],
    // //   ], $params),
    // // $options);
    // //
    //
    // $amount = 1000;
    // $currency = 'eur';
    //
    // // Create a PaymentIntent with amount and currency
    // $paymentIntent = \Stripe\PaymentIntent::create([
    //   'amount' => $amount,
    //   'currency' => $currency,
    //   'automatic_payment_methods' => [
    //       'enabled' => true,
    //   ],
    // ]);
    //
    // return $paymentIntent;
  }
}
