<?php

return [
  [
    'pattern' => '(:any).json',
    'action'  => function () {
      $customHeader = $_SERVER['HTTP_X_REQUESTED_WITH'] ?? null;

      // Secure JSON output from direct access in production environment
      if (option('debug') === false && $customHeader !== 'fetch') {
        go(url('error'));
      }

      $this->next();
    }
  ],
  [
    'pattern' => 'cartAddItem',
    'method' => 'post',
    'action'  => function () {
      try {
        $cart = cart();
        $id = get('id');
        $quantity = get('quantity');
        $cart->addItem($id, $quantity);

        $json = $cart->toJsonForVue();

        return json_encode($json);
      } catch (\Exception $e) {
        throw new \Exception("Item couldn't be added to cart", 1);
      }
    }
  ],
  [
    'pattern' => 'getCart',
    'method' => 'get',
    'action' => function () {
      /* Secure the route with */

      $customHeader = $_SERVER['HTTP_X_REQUESTED_WITH'] ?? null;

      if (option('debug') === false && $customHeader !== 'XMLHttpRequest') {
        go(url('error'));
      }

      $cart = cart();
      $json = $cart->toJsonForVue();
      return json_encode($json);
    }
  ],
  [
    'pattern' => 'checkoutSessionCompleted',
    'method' => 'post',
    'action' => function () {
      $kirby = kirby();
      // This is your test secret API key.
      payments()::setStripeApiKey();
      // Replace this endpoint secret with your endpoint's unique secret
      // If you are testing with the CLI, find the secret by running 'stripe listen'
      // If you are using an endpoint defined with the API or dashboard, look in your webhook settings
      // at https://dashboard.stripe.com/webhooks
      $endpoint_secret = $kirby->option('wizhou.magasin.stripe.test.stripeWebhooks');

      $payload = @file_get_contents('php://input');
      $event = null;

      try {
        $event = \Stripe\Event::constructFrom(
          json_decode($payload, true)
        );
      } catch(\UnexpectedValueException $e) {
        // Invalid payload
        echo '⚠️  Webhook error while parsing basic request.';
        http_response_code(400);
        exit();
      }

      if ($endpoint_secret) {
        // Only verify the event if there is an endpoint secret defined
        // Otherwise use the basic decoded event
        $sig_header = $_SERVER['HTTP_STRIPE_SIGNATURE'];
        try {
          $event = \Stripe\Webhook::constructEvent(
            $payload, $sig_header, $endpoint_secret
          );
        } catch(\Stripe\Exception\SignatureVerificationException $e) {
          // Invalid signature
          echo '⚠️  Webhook error while validating signature.';
          http_response_code(400);
          exit();
        }
      }

      // Handle the event

      $session_id = $event->data->object->id;
      echo $session_id;

      $line_items = \Stripe\Checkout\Session::allLineItems($session_id);

      foreach ($line_items->data as $product) {

        /* Get the product id for Stripe */
        $stripeProdcutId = $product->price->product;

        /* Retrive the prodcut from stripe */
        $stripeProdcut = \Stripe\Product::retrieve(
          $stripeProdcutId,
          []
        );

        /* Get the page within the site with the uuid */
        $uuid = $stripeProdcut->metadata->uuid;
        $productPage = $kirby->site()->find($uuid);

        /* Calculate the quantity and stock */
        $baseQuantity = $productPage->quantity();
        $orderQuantity = $product->quantity;
        $newQuantity = $baseQuantity - $orderQuantity;

        /* Give the code permission to udpate the page */
        $kirby->impersonate('kirby');
        /* Update the stock */
        $productPage->update([
          'stock' => $newQuantity
        ]);
      }

      http_response_code(200);
      return 'hello';
    }
  ]
];
