<li class="cart-item">
  <div class="cart-item-header">
    <a
      href="<?= $product->toPage()->url(); ?>"
      class="cart-item-link row align-items-center"
    >
      <div class="cart-item-cover ">
        <?php $img = $product->toPage()->getCover('cartImage'); ?>
        <img
          src="<?= $img['src']; ?>"
          srcset="<?= $img['srcset']; ?>"
          class="lazyload"
          data-src="<?= $img['src']; ?>"
          data-srcset="<?= $img['srcset']; ?>"
          data-sizes="auto"
          alt="<?= $img['alt']; ?>"
        >
      </div>
      <div class="cart-item-title col-tiny-12">
        <h3 class="headings-unmarged"><?= $product->toPage()->title(); ?></h3>
        <div class="cart-item-authors lead">
          <?= join(' & ', $product->toPage()->authors()->toPages()->pluck('title', null, true)); ?>
        </div>
      </div>
    </a>
  </div>
  <form
    class="cart-item-footer"
    name="cart-item-controls"
    method="post"
    target="_self"
  >
    <fieldset name="cart-item-controls row">
      <input
        type="hidden"
        name="product-id"
        value="<?= $product->id(); ?>"
      >
      <div class="row">
        <div class="cart-item-control cart-item-price col-3 col-mobile-12">
          <label for="price">Prix unitaire</label>
          <div class="lead" name="price"><?= currency()->prettify(
            $product->priceIncludingTax()
          ); ?></div>
          <hr class="cart-item-divider show-mobile">
        </div>
        <div class="cart-item-control cart-item-quantity col-4 col-mobile-12">
          <label for="cart-item-quantity">Quantité</label>
          <div class="row">
            <select class="form-element lead" name="cart-item-quantity">
              <?php for ($i=1; $i <= $product->stock(); $i++): ?>
                <option
                  value="<?= $i; ?>"
                  <?php if ($i === $product->quantity()) echo 'selected'; ?>
                ><?= $i; ?></option>
              <?php endfor; ?>
            </select>
            <button
              class="button button-circle button-tertiary button-icon"
              type="submit"
            ><span class="icon-check"></span></button>
          </div>
          <hr class="cart-item-divider show-mobile">
        </div>
        <div class="cart-item-control cart-item-total col-3 col-mobile-12">
          <label for="total">Total</label>
          <div name="total" class="lead">
            <?= currency()->prettify(
              $product->sumIncludingTax()
            ); ?>
          </div>
          <hr class="cart-item-divider show-mobile">
        </div>
        <div class="cart-item-control cart-item-remove col-2 col-mobile-12 lead">
          <button
            class="button button-icon button-circle button-clean"
            name="remove-item"
            value="true"
            type="submit"
          >
            <span class="icon-trash-o"></span>
          </button>
        </div>
      </div>
    </fieldset>
  </form>
</li>
