<?php snippet('layout', slots: true); ?>

<?php slot('content'); ?>
  <main class="flow">
    <div class="content">
      <?php foreach ($page->text()->toLayouts() as $layout): ?>
        <div
          class="content-item grid row justify-content-center align-items-center"
          id="<?= $layout->id() ?>"
        >
          <?php foreach ($layout->columns() as $column): ?>
          <div class="content-column aperture col-<?= $column->span() ?>">
            <div class="blocks">
              <?php snippet('components/content', [
                'blocks' => $column->blocks(),
                'column' => $column,
                'layout' => $layout
              ]
              ); ?>
            </div>
          </div>
          <?php endforeach ?>
        </div>
      <?php endforeach ?>
    </div>
  </main>
<?php endslot(); ?>